/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs.replayoverridewizard;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.ui.dialogs.replayoverridewizard.AbstractSecondPage;
import com.arm.mgd.ui.dialogs.replayoverridewizard.ModifyPrecisionOverridePage;
import com.arm.mgd.ui.dialogs.replayoverridewizard.ModifyProgramAssetPage;
import com.arm.mgd.ui.dialogs.replayoverridewizard.SelectTextureAssetPage;
import com.arm.mgd.ui.utils.AssetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class MinimalFrameReplayOverrideWizard
extends Wizard {
    private AbstractSecondPage<? extends IAssetItem> currentPage = null;
    private final @NonNull TraceDataModel model;
    private final Collection<? extends IAssetItem> assetItemList;
    private final AbstractSecondPage.Mode mode;

    public MinimalFrameReplayOverrideWizard(@NonNull TraceStateSnapshot latestSnapshot, @NonNull TraceStateSnapshot selectedSnapshot, FrameOverrides.OverrideType overrideType, Collection<? extends IAssetItem> assetItemList, AbstractSecondPage.Mode mode) {
        this.model = latestSnapshot.getModel();
        this.assetItemList = assetItemList;
        this.mode = mode;
        this.currentPage = MinimalFrameReplayOverrideWizard.createCurrentPage(latestSnapshot, selectedSnapshot, overrideType, assetItemList, mode);
    }

    public MinimalFrameReplayOverrideWizard(@NonNull TraceStateSnapshot latestSnapshot, @NonNull TraceStateSnapshot selectedSnapshot, FrameOverrides.OverrideType overrideType, @NonNull AbstractFrameOverride afo) {
        this.model = latestSnapshot.getModel();
        this.assetItemList = null;
        this.mode = AbstractSecondPage.Mode.EDIT;
        this.currentPage = MinimalFrameReplayOverrideWizard.createCurrentPage(latestSnapshot, selectedSnapshot, overrideType, this.assetItemList, this.mode);
        if (this.currentPage != null) {
            this.currentPage.setEditableOverride(afo);
        }
    }

    public static <T extends IAssetItem> @NonNull Map<String, T> getRelevantAssetsToBeShown(@NonNull TraceStateSnapshot snapshot, FrameOverrides.OverrideType overrideType, Collection<T> itemList, AbstractSecondPage.Mode mode) {
        IAssetItem asset;
        Iterator it;
        HashMap<String, IAssetItem> dataSource = new HashMap<String, IAssetItem>();
        ArrayList<T> filteredItemList = new ArrayList<T>(itemList);
        if (mode == AbstractSecondPage.Mode.ADD) {
            it = filteredItemList.iterator();
            while (it.hasNext()) {
                asset = (IAssetItem)it.next();
                assert (overrideType != null);
                assert (asset != null);
                if (!snapshot.getModel().getCurrentActiveOverrides().contains(overrideType, asset)) continue;
                it.remove();
            }
        } else {
            it = filteredItemList.iterator();
            while (it.hasNext()) {
                asset = (IAssetItem)it.next();
                assert (overrideType != null);
                assert (asset != null);
                if (snapshot.getModel().getCurrentActiveOverrides().contains(overrideType, asset)) continue;
                it.remove();
            }
        }
        for (IAssetItem asset2 : filteredItemList) {
            assert (asset2 != null) : "Not expecting the asset to be null.";
            dataSource.put(asset2.getLabelText(), asset2);
        }
        return dataSource;
    }

    private static AbstractSecondPage<? extends IAssetItem> createCurrentPage(@NonNull TraceStateSnapshot latestSnapshot, @NonNull TraceStateSnapshot selectedSnapshot, FrameOverrides.OverrideType overrideType, Collection<? extends IAssetItem> assetItemList, AbstractSecondPage.Mode mode) {
        AbstractSecondPage page = null;
        switch (overrideType) {
            case FORCE_PRECISION_OVERRIDE: {
                Map<String, Object> dataSource = assetItemList != null ? MinimalFrameReplayOverrideWizard.getRelevantAssetsToBeShown(selectedSnapshot, overrideType, assetItemList, mode) : AssetUtils.getLabelAssetMap(GlProgramAsset.class, KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC, latestSnapshot);
                Map<String, ? extends IAssetItem> castDataSource = dataSource;
                page = new ModifyPrecisionOverridePage(null, mode, selectedSnapshot, castDataSource);
                break;
            }
            case PROGRAM_OVERRIDE: {
                Map<String, Object> dataSource = assetItemList != null ? MinimalFrameReplayOverrideWizard.getRelevantAssetsToBeShown(selectedSnapshot, overrideType, assetItemList, mode) : AssetUtils.getLabelAssetMap(GlProgramAsset.class, KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC, latestSnapshot);
                Map<String, ? extends IAssetItem> castDataSource = dataSource;
                page = new ModifyProgramAssetPage(null, mode, selectedSnapshot, castDataSource);
                break;
            }
            case TEXTURE_OVERRIDE: {
                Map<String, Object> dataSource = assetItemList != null ? MinimalFrameReplayOverrideWizard.getRelevantAssetsToBeShown(selectedSnapshot, overrideType, assetItemList, mode) : AssetUtils.getLabelAssetMap(GlTextureAsset.class, KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC, latestSnapshot);
                Map<String, ? extends IAssetItem> castDataSource = dataSource;
                page = new SelectTextureAssetPage(null, "Select a texture to override:", latestSnapshot, selectedSnapshot, castDataSource);
                break;
            }
        }
        return page;
    }

    public String getWindowTitle() {
        return "New Frame Replay Override";
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        switch (this.mode) {
            case ADD: {
                List<AbstractFrameOverride> overrides = this.currentPage.createOverride();
                if (overrides == null) {
                    return true;
                }
                FrameOverrides modelOverrides = this.model.getCurrentActiveOverrides();
                for (AbstractFrameOverride override : overrides) {
                    if (modelOverrides.containsSimilar(override)) continue;
                    assert (override != null);
                    modelOverrides.add(override);
                }
                break;
            }
            case EDIT: {
                this.currentPage.editOverride();
                this.model.getCurrentActiveOverrides().refresh();
                break;
            }
            case REMOVE: {
                this.currentPage.removeOverride();
                this.model.getCurrentActiveOverrides().refresh();
                break;
            }
        }
        return true;
    }

    public IWizardPage getStartingPage() {
        return this.currentPage;
    }
}

