/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs.replayoverridewizard;

import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractComboboxWizardPage<VALUE_TYPE>
extends WizardPage {
    private static final String ALL_TEXT = "All";
    private final @NonNull Map<String, VALUE_TYPE> dataSource;
    private final @NonNull String labelText;
    private boolean selectedAll = false;
    private @Nullable VALUE_TYPE selectedValue = null;

    protected AbstractComboboxWizardPage(@NonNull String pageTitle, @NonNull String labelText, @NonNull Map<String, VALUE_TYPE> dataSource) {
        super(pageTitle);
        this.labelText = labelText;
        this.dataSource = dataSource;
    }

    public boolean canFlipToNextPage() {
        return this.selectedValue != null && this.getWizard().getNextPage((IWizardPage)this) != null;
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.createAdditionalControlsBefore(container);
        final Combo combo = this.createComboBox(container, this.labelText);
        int i = 0;
        if (this.allowAllOverride()) {
            combo.add(ALL_TEXT);
            combo.select(0);
            this.setSelectedAll(true);
            ++i;
        }
        VALUE_TYPE defaultSelection = this.getDefaultSelection();
        for (Map.Entry<String, VALUE_TYPE> item : this.dataSource.entrySet()) {
            combo.add(item.getKey());
            VALUE_TYPE value = item.getValue();
            assert (value != null);
            if (value.equals(defaultSelection)) {
                combo.select(i);
                this.setSelectedAll(false);
                this.setSelectedValue(value);
            }
            ++i;
        }
        combo.setVisibleItemCount(5);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                if (AbstractComboboxWizardPage.this.allowAllOverride() && AbstractComboboxWizardPage.ALL_TEXT.equals(combo.getText())) {
                    AbstractComboboxWizardPage.this.setSelectedValue(null);
                    AbstractComboboxWizardPage.this.setSelectedAll(true);
                } else {
                    AbstractComboboxWizardPage.this.setSelectedAll(false);
                    AbstractComboboxWizardPage.this.setSelectedValue(AbstractComboboxWizardPage.this.dataSource.get(combo.getText()));
                }
            }

            public void widgetSelected(SelectionEvent event) {
                this.widgetDefaultSelected(event);
            }
        });
        this.createAdditionalControlsAfter(container);
        this.setControl((Control)container);
    }

    public Map<String, VALUE_TYPE> getDataSource() {
        return this.dataSource;
    }

    public @Nullable VALUE_TYPE getSelectedValue() {
        return this.selectedValue;
    }

    public boolean isSelectedAll() {
        return this.selectedAll;
    }

    protected boolean allowAllOverride() {
        return false;
    }

    protected void createAdditionalControlsAfter(Composite container) {
    }

    protected void createAdditionalControlsBefore(Composite container) {
    }

    protected Combo createComboBox(Composite container, String comboLabelText) {
        Label label = new Label(container, 0);
        Combo combo = new Combo(container, 8);
        label.setText(comboLabelText);
        return combo;
    }

    protected abstract VALUE_TYPE getDefaultSelection();

    protected boolean getPageComplete() {
        return this.selectedAll || this.selectedValue != null;
    }

    protected final void setPageComplete() {
        this.setPageComplete(this.getPageComplete());
    }

    protected void setSelectedAll(boolean selectedAll) {
        this.selectedAll = selectedAll && this.allowAllOverride();
        this.setPageComplete();
    }

    protected void setSelectedValue(@Nullable VALUE_TYPE selectedValue) {
        this.selectedValue = selectedValue;
        this.setPageComplete();
    }
}

