/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs;

import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.ui.controllers.ProcessReplayUploaderDialogController;
import com.arm.mgd.ui.controls.HybridModalWindow;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.eclipse.jdt.annotation.NonNull;

public class ProcessReplayUploaderDialog
extends HybridModalWindow {
    @FXML
    private DialogPane dialogPane;
    @FXML
    private Text messageText;
    @FXML
    private VBox androidDeviceControlBox;
    @FXML
    private TitledPane taskControlPane;
    @FXML
    private Button uploadButton;
    @FXML
    private Button cancelButton;
    private final @NonNull ProcessReplayUploaderDialogController controller;
    private static final @NonNull String MAIN_MESSAGE = "Select an Android device to upload the process to be replayed.\nPlease note that Full Trace Replay currently only supports replaying on the source device\nusing the same configuration (driver version, OpenGL ES library, etc) as the original trace.";
    private static final @NonNull String TITLE = "Process Replay Uploader";

    public ProcessReplayUploaderDialog(int processID, @NonNull AbstractTarget target) {
        this.controller = new ProcessReplayUploaderDialogController(processID, target);
        this.setShellListener(this.controller.getShellListener());
    }

    @Override
    protected void configureScene() {
        this.messageText.setText(MAIN_MESSAGE);
        this.androidDeviceControlBox.getChildren().add((Object)this.controller.getAndroidDeviceControl());
        VBox.setVgrow((Node)this.controller.getAndroidDeviceControl(), (Priority)Priority.ALWAYS);
        this.uploadButton.disableProperty().bind((ObservableValue)ProcessReplayUploaderDialogController.getUploadingProperty().or((ObservableBooleanValue)this.controller.getAndroidDeviceControl().getSelectedItemProperty().isNull()));
        this.uploadButton.onActionProperty().set(event -> this.controller.uploadMarshalledTrace());
        this.cancelButton.disableProperty().bind((ObservableValue)ProcessReplayUploaderDialogController.getUploadingCancelledProperty().or((ObservableBooleanValue)ProcessReplayUploaderDialogController.getUploadingProperty().not()));
        this.cancelButton.onActionProperty().set(event -> this.controller.cancelMarshalling());
        this.setShellListener(this.controller.getShellListener());
    }

    @Override
    protected void setFocus() {
        this.androidDeviceControlBox.requestFocus();
    }

    @Override
    protected String getTitle() {
        return TITLE;
    }

    @Override
    protected String getFXMLFilename() {
        return "/resources/dialogs/processReplayUploaderDialog.fxml";
    }

    @Override
    protected void onDispose() {
        this.controller.getAndroidDeviceControl().dispose();
    }
}

