/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs;

import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.ProcessMarshaller;
import com.arm.mgd.core.target.io.ProcessTarget;
import com.arm.mgd.core.target.marshaller.utils.ReplayValidator;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.ProcessReplaySelectorDialogController;
import com.arm.mgd.ui.controls.HybridModalWindow;
import com.arm.mgd.ui.dialogs.ProcessReplayUploaderDialog;
import com.arm.mgd.utils.VersionProperties;
import java.util.List;
import java.util.Optional;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DialogPane;
import javafx.scene.text.Text;
import javafx.util.StringConverter;

public class ProcessReplaySelectorDialog
extends HybridModalWindow {
    @FXML
    private DialogPane dialogPane;
    @FXML
    private Text messageText;
    @FXML
    private Text analysisText;
    @FXML
    private ComboBox<ProcessTarget> processMenu;

    @Override
    protected void configureScene() {
        Button ok = (Button)this.dialogPane.lookupButton(ButtonType.OK);
        ok.setOnAction(event -> {
            this.dispose();
            ProcessTarget process = (ProcessTarget)this.processMenu.getSelectionModel().getSelectedItem();
            assert (process != null);
            new ProcessReplayUploaderDialog(process.getProcessID(), process.getParentTarget()).showAndWait();
        });
        this.analysisText.textProperty().addListener((observable, oldValue, newValue) -> this.updateSize());
        this.processMenu.valueProperty().addListener((observable, oldValue, newValue) -> {
            try {
                ReplayValidator.ReplayabilityAnalysis analysis = ReplayValidator.isProcessReplayable((int)newValue.getProcessID(), (AbstractTarget)newValue.getParentTarget());
                ok.setDisable(!analysis.isReplayable());
                if (analysis.isReplayable()) {
                    this.analysisText.setText("No issues were detected.");
                } else {
                    StringBuilder sb = new StringBuilder("The selected process is not replayable for the following reason(s): ").append(System.lineSeparator());
                    for (ReplayValidator.ReplayFailureCondition failureCondition : analysis.getReasonsForFailure()) {
                        sb.append(System.lineSeparator()).append(failureCondition);
                    }
                    this.analysisText.setText(sb.toString());
                }
            }
            catch (ProcessMarshaller.NoProcessFoundException e) {
                assert (false);
                this.analysisText.setText(String.valueOf(VersionProperties.FULL_PRODUCT_NAME) + " encountered an error looking up the selected process.");
                ok.setDisable(true);
                CoreLogging.severe(null, (Throwable)e, (String)"Error validating process for Full Trace Replay.");
            }
        });
        List<ProcessTarget> processes = ProcessReplaySelectorDialogController.getCurrentProcessTargets();
        this.processMenu.setConverter(new ProcessTargetConverter());
        this.processMenu.getItems().setAll(processes);
        this.processMenu.getSelectionModel().selectFirst();
        this.messageText.setText("Select a process to replay from the process(es) below:");
    }

    @Override
    protected void setFocus() {
        this.dialogPane.requestFocus();
    }

    @Override
    protected String getTitle() {
        return "Process Replayer";
    }

    @Override
    protected String getFXMLFilename() {
        return "/resources/dialogs/processReplaySelectorDialog.fxml";
    }

    @Override
    protected void onDispose() {
    }

    private static class ProcessTargetConverter<T>
    extends StringConverter<ProcessTarget> {
        private ProcessTargetConverter() {
        }

        public ProcessTarget fromString(String string) {
            Optional<ProcessTarget> target = ProcessReplaySelectorDialogController.getCurrentProcessTargets().stream().filter(pt -> pt.getModel().getIdentifierString().equals(string)).findAny();
            return target.orElse(null);
        }

        public String toString(ProcessTarget object) {
            return object.getModel().getIdentifierString();
        }
    }
}

