/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs;

import com.arm.mgd.core.util.deviceinfo.EglConfigInfo;
import com.arm.mgd.ui.controllers.AndroidDeviceControlItemFrameBufferConfig;
import com.arm.mgd.ui.controls.HybridModalWindow;
import com.arm.mgd.ui.dialogs.ClickThroughConfirmationDialog;
import com.arm.mgd.ui.dialogs.SimpleModalMessageDialog;
import com.arm.mgd.ui.preferences.PreferenceConstant;
import com.arm.mgd.utils.VersionProperties;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProcessReplayFrameBufferConfig
extends HybridModalWindow {
    @FXML
    protected TableView<EglConfigInfo> configsTable;
    @FXML
    protected TableView<Map.Entry<String, String>> attribsTable;
    @FXML
    private TableColumn<@NonNull EglConfigInfo, Integer> configIDColumn;
    @FXML
    private TableColumn<@NonNull EglConfigInfo, String> configLabelColumn;
    @FXML
    private TableColumn<Map.Entry<String, String>, String> attribColumn;
    @FXML
    private TableColumn<Map.Entry<String, String>, String> valueColumn;
    @FXML
    private CheckBox forceConfigCheckBox;
    @FXML
    private TextField targetResolutionX;
    @FXML
    private TextField targetResolutionY;
    @FXML
    private Button cancelButton;
    @FXML
    private Button okButton;
    @FXML
    private CheckBox forceResolutionCheckBox;
    private @NonNull AndroidDeviceControlItemFrameBufferConfig framebufferConfig;
    private static final @NonNull String FORCE_CONFIG_WARNING_TITLE = "Forcing configuration";
    private static final @NonNull String FORCE_CONFIG_WARNING_MESSAGE = "You are about to force the Full Trace Replay configuration parameters." + System.lineSeparator() + System.lineSeparator() + "The replay may not work as expected or not work at all, depending on the selected parameters." + System.lineSeparator() + "For example the selected resolution may not be valid for the device or the selected EGL configuration breaks some assumptions made by the originally traced application." + System.lineSeparator() + System.lineSeparator() + "Please refer to the " + VersionProperties.FULL_PRODUCT_NAME + " User Guide for more details.";

    public ProcessReplayFrameBufferConfig(@NonNull AndroidDeviceControlItemFrameBufferConfig framebufferConfig) {
        this.framebufferConfig = framebufferConfig;
    }

    @Override
    protected void configureScene() {
        ArrayList<EglConfigInfo> configs = this.framebufferConfig.getAvalaibleConfigs();
        @Nullable Map attribs = null;
        if (configs != null && !configs.isEmpty()) {
            this.configsTable.setItems(FXCollections.observableArrayList(configs));
            attribs = configs.get(0).getAttribs();
        } else {
            new SimpleModalMessageDialog("Error", "Reading the device's available EGL config has timed out.\nPlease try re-opening the dialog again.").showAndWait();
        }
        this.configsTable.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection == null) {
                this.attribsTable.setItems(FXCollections.emptyObservableList());
                return;
            }
            this.attribsTable.setItems(FXCollections.observableArrayList(newSelection.getAttribs().entrySet()));
        });
        this.configLabelColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<EglConfigInfo, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(// Could not load outer class - annotation placement on inner may be incorrect
            TableColumn.CellDataFeatures<@NonNull EglConfigInfo, String> param) {
                EglConfigInfo eglConfig = (EglConfigInfo)param.getValue();
                return new SimpleStringProperty("EGL_" + eglConfig.getLabel());
            }
        });
        this.attribsTable.setSelectionModel(null);
        if (attribs != null && !attribs.isEmpty()) {
            this.attribsTable.setItems(FXCollections.observableArrayList(attribs.entrySet()));
        } else if (configs != null && configs.size() > 0) {
            new SimpleModalMessageDialog("Error", "Reading the device's available EGL config has timed out.\nPlease try re-opening the dialog again.").showAndWait();
        }
        this.attribsTable.getColumns().set(0, this.attribColumn);
        this.attribsTable.getColumns().set(1, this.valueColumn);
        this.attribColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Map.Entry<String, String>, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Map.Entry<String, String>, String> param) {
                return new SimpleStringProperty((String)((Map.Entry)param.getValue()).getKey());
            }
        });
        this.attribColumn.setSortable(false);
        this.valueColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Map.Entry<String, String>, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Map.Entry<String, String>, String> param) {
                return new SimpleStringProperty((String)((Map.Entry)param.getValue()).getValue());
            }
        });
        this.valueColumn.setSortable(false);
        this.cancelButton.setOnAction(action -> this.dispose());
        this.okButton.setOnAction(action -> {
            block7: {
                if (this.forceConfigCheckBox.isSelected()) {
                    if (this.configsTable.getSelectionModel().selectedIndexProperty().intValue() == -1) {
                        new SimpleModalMessageDialog("Input Validation", "Please make sure a framebuffer config is selected.").showAndWait();
                        return;
                    }
                    @Nullable EglConfigInfo eglConfig = (EglConfigInfo)this.configsTable.getSelectionModel().getSelectedItem();
                    this.framebufferConfig.setConfig(eglConfig);
                } else {
                    this.framebufferConfig.resetConfig();
                }
                if (this.forceResolutionCheckBox.isSelected()) {
                    @Nullable String pattern = "[1-9][0-9]*";
                    String strX = this.targetResolutionX.getText();
                    String strY = this.targetResolutionY.getText();
                    if (strX.matches(pattern) && strY.matches(pattern)) {
                        this.framebufferConfig.setResolution(Integer.parseInt(strX), Integer.parseInt(strY));
                        break block7;
                    } else {
                        new SimpleModalMessageDialog("Input Validation", "Please make sure the resolution values are valid.").showAndWait();
                        return;
                    }
                }
                this.framebufferConfig.resetResolution();
            }
            if ((this.forceConfigCheckBox.isSelected() || this.forceResolutionCheckBox.isSelected()) && !ProcessReplayFrameBufferConfig.hasUserAcceptedForceConfigWarning()) {
                return;
            }
            this.dispose();
        });
        this.forceConfigCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    ProcessReplayFrameBufferConfig.this.configsTable.setDisable(false);
                    ProcessReplayFrameBufferConfig.this.attribsTable.setDisable(false);
                } else {
                    ProcessReplayFrameBufferConfig.this.configsTable.setDisable(true);
                    ProcessReplayFrameBufferConfig.this.attribsTable.setDisable(true);
                }
            }
        });
        this.forceResolutionCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> o, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    ProcessReplayFrameBufferConfig.this.targetResolutionX.setDisable(false);
                    ProcessReplayFrameBufferConfig.this.targetResolutionY.setDisable(false);
                } else {
                    ProcessReplayFrameBufferConfig.this.targetResolutionX.setDisable(true);
                    ProcessReplayFrameBufferConfig.this.targetResolutionY.setDisable(true);
                }
            }
        });
        if (((AndroidDeviceControlItemFrameBufferConfig.Info)this.framebufferConfig.infoProperty().getValue()).getStatus() == AndroidDeviceControlItemFrameBufferConfig.FrameBufferConfigStatus.FB_VP_FORCED) {
            this.forceResolutionCheckBox.setSelected(true);
            this.targetResolutionX.setText(Integer.toString(this.framebufferConfig.getResolution().getWidth()));
            this.targetResolutionY.setText(Integer.toString(this.framebufferConfig.getResolution().getHeight()));
            this.forceConfigCheckBox.setSelected(true);
            EglConfigInfo forcedConfig = this.framebufferConfig.getConfig();
            if (forcedConfig != null) {
                this.configsTable.getSelectionModel().select((Object)forcedConfig);
                this.attribsTable.setItems(FXCollections.observableArrayList(forcedConfig.getAttribs().entrySet()));
            }
        } else if (((AndroidDeviceControlItemFrameBufferConfig.Info)this.framebufferConfig.infoProperty().getValue()).getStatus() == AndroidDeviceControlItemFrameBufferConfig.FrameBufferConfigStatus.VP_FORCED) {
            this.forceResolutionCheckBox.setSelected(true);
            this.targetResolutionX.setText(Integer.toString(this.framebufferConfig.getResolution().getWidth()));
            this.targetResolutionY.setText(Integer.toString(this.framebufferConfig.getResolution().getHeight()));
            this.configsTable.setDisable(true);
            this.attribsTable.setDisable(true);
        } else if (((AndroidDeviceControlItemFrameBufferConfig.Info)this.framebufferConfig.infoProperty().getValue()).getStatus() == AndroidDeviceControlItemFrameBufferConfig.FrameBufferConfigStatus.FB_FORCED) {
            this.forceConfigCheckBox.setSelected(true);
            EglConfigInfo forcedConfig = this.framebufferConfig.getConfig();
            if (forcedConfig != null) {
                this.configsTable.getSelectionModel().select((Object)forcedConfig);
                this.attribsTable.setItems(FXCollections.observableArrayList(forcedConfig.getAttribs().entrySet()));
            }
            this.targetResolutionX.setDisable(true);
            this.targetResolutionY.setDisable(true);
        } else {
            this.configsTable.setDisable(true);
            this.attribsTable.setDisable(true);
            this.targetResolutionX.setDisable(true);
            this.targetResolutionY.setDisable(true);
        }
    }

    @Override
    protected void setFocus() {
        this.okButton.requestFocus();
    }

    @Override
    protected String getTitle() {
        return "Force Configuration";
    }

    @Override
    protected String getFXMLFilename() {
        return "/resources/dialogs/processReplayFrameBufferConfig.fxml";
    }

    @Override
    protected boolean isResizeable() {
        return true;
    }

    @Override
    protected boolean closeOnEscape() {
        return true;
    }

    @Override
    protected void onDispose() {
    }

    private static boolean hasUserAcceptedForceConfigWarning() {
        return ProcessReplayFrameBufferConfig.hasUserAcceptedWarning(PreferenceConstant.ACCEPTED_FORCE_CONFIG_WARNING, FORCE_CONFIG_WARNING_TITLE, FORCE_CONFIG_WARNING_MESSAGE);
    }

    private static boolean hasUserAcceptedWarning(@NonNull PreferenceConstant preference, @NonNull String warningTitle, @NonNull String warningMessage) {
        IPreferenceStore preferenceStore = PreferenceConstant.getPreferenceStore();
        if (preferenceStore.getBoolean(preference.getPreferenceName())) {
            return true;
        }
        Optional<Boolean> dontShowAgain = new ClickThroughConfirmationDialog(warningTitle, warningMessage, true, true).showAndWaitForResult();
        if (!dontShowAgain.isPresent()) {
            return false;
        }
        if (dontShowAgain.get().booleanValue()) {
            preferenceStore.setValue(preference.getPreferenceName(), true);
        }
        return true;
    }
}

