/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs;

import com.arm.mgd.core.authorisation.Feature;
import com.arm.mgd.ui.controls.HybridModalDialog;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.text.Text;
import org.eclipse.jdt.annotation.NonNull;

public class LicenseFeatureNotAvailableDialog
extends HybridModalDialog<Void> {
    private static final @NonNull String FXML_FILE_PATH = "/resources/dialogs/licenseFeatureNotAvailableDialog.fxml";
    private static final @NonNull String NO_LICENSE_FEATURE_TITLE = "License Feature Not Available";
    @FXML
    private Text authorisationReasonText;
    private ButtonBase okButton;
    private @NonNull Feature feature;
    private @NonNull String message;

    public LicenseFeatureNotAvailableDialog(@NonNull Feature feature, @NonNull String message) {
        this.feature = feature;
        this.message = message;
    }

    @Override
    protected void configureDialog() {
        this.okButton = this.getButton(ButtonType.OK);
        assert (this.okButton != null);
        this.okButton.setOnAction(actionEvent -> this.dispose());
        StringBuilder sb = new StringBuilder();
        sb.append("Trying to check out a license for '").append(this.feature.getLabel()).append("' failed with the following message: ").append(this.message).append(System.lineSeparator()).append(System.lineSeparator()).append(this.feature.getLicenceMissingMessage());
        this.authorisationReasonText.setText(sb.toString());
    }

    @Override
    protected void setFocus() {
        this.okButton.requestFocus();
    }

    @Override
    protected String getTitle() {
        return NO_LICENSE_FEATURE_TITLE;
    }

    @Override
    protected String getFXMLFilename() {
        return FXML_FILE_PATH;
    }

    public static void show(@NonNull Feature feature, @NonNull String message) {
        Platform.runLater(() -> new LicenseFeatureNotAvailableDialog(feature, message).showAndWait());
    }

    @Override
    protected void onDispose() {
    }
}

