/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs;

import com.arm.mgd.core.asset.ClKernelAsset;
import com.arm.mgd.core.asset.ComputeWorkgroupSize;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LaunchGpuVerifyDialog
extends TitleAreaDialog {
    private final @NonNull List<@NonNull KernelSourcePair> kernelAssets;
    private final @NonNull Map<@NonNull String, KernelSourcePair> labelToAssetMap = new HashMap<String, KernelSourcePair>();
    private @NonNull KernelSourcePair selectedAsset;
    private ComputeWorkgroupSize localSize;
    private ComputeWorkgroupSize globalSize;
    private String buildOptions;
    private Combo kernelNameComboBox;
    private Combo localSizeComboBox;
    private Combo globalSizeComboBox;
    private Text buildOptionsTextBox;

    public LaunchGpuVerifyDialog(Shell parentShell, @NonNull List<@NonNull KernelSourcePair> assets) {
        super(parentShell);
        assert (!assets.isEmpty());
        this.kernelAssets = assets;
        this.selectedAsset = assets.get(0);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    void updateTextBoxes() {
        @NonNull ClKernelAsset kernel = this.selectedAsset.kernelAsset;
        @NonNull List invocations = kernel.getInvocationHistory();
        this.localSizeComboBox.removeAll();
        this.globalSizeComboBox.removeAll();
        HashSet<@NonNull String> localSizeSet = new HashSet<String>();
        HashSet<@NonNull String> globalSizeSet = new HashSet<String>();
        int i = invocations.size() - 1;
        while (i >= 0) {
            String globalWorkSizeString;
            String localWorkSizeString;
            ClKernelAsset.KernelInvocation invocation = (ClKernelAsset.KernelInvocation)invocations.get(i);
            ComputeWorkgroupSize localWorkSize = invocation.localWorkSize;
            String string = localWorkSizeString = localWorkSize == null ? "" : localWorkSize.toString();
            if (localSizeSet.add(localWorkSizeString)) {
                this.localSizeComboBox.add(localWorkSizeString);
            }
            if (globalSizeSet.add(globalWorkSizeString = invocation.globalWorkSize.toString())) {
                this.globalSizeComboBox.add(globalWorkSizeString);
            }
            --i;
        }
        this.localSizeComboBox.select(0);
        this.globalSizeComboBox.select(0);
        if (kernel.getProgramAsset().getBuildOptions() != null) {
            this.buildOptionsTextBox.setText(kernel.getProgramAsset().getBuildOptions());
        } else {
            this.buildOptionsTextBox.setText("");
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite c = new Composite(container, 2048);
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        c.setLayout((Layout)new GridLayout(2, false));
        this.setTitle("Run Kernel Through GPUVerify");
        this.setMessage("All live kernel objects at the currently selected function call that have their full source code available are shown.");
        new Label(c, 0).setText("Kernel (ProgramID::KernelID):");
        this.kernelNameComboBox = new Combo(c, 8);
        for (KernelSourcePair asset : this.kernelAssets) {
            this.kernelNameComboBox.add(asset.kernelAsset.getLabelText());
            this.labelToAssetMap.put(asset.kernelAsset.getLabelText(), asset);
        }
        this.kernelNameComboBox.select(0);
        this.kernelNameComboBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                KernelSourcePair asset = LaunchGpuVerifyDialog.this.labelToAssetMap.get(LaunchGpuVerifyDialog.this.kernelNameComboBox.getText());
                if (!$assertionsDisabled && asset == null) {
                    throw new AssertionError();
                }
                LaunchGpuVerifyDialog.this.selectedAsset = asset;
                LaunchGpuVerifyDialog.this.updateTextBoxes();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        new Label(c, 0).setText("Local Work Size:");
        this.localSizeComboBox = new Combo(c, 4);
        this.localSizeComboBox.setLayoutData((Object)new GridData(4, 0, true, false));
        new Label(c, 0).setText("Global Work Size:");
        this.globalSizeComboBox = new Combo(c, 4);
        this.globalSizeComboBox.setLayoutData((Object)new GridData(4, 0, true, false));
        new Label(c, 0).setText("Kernel Build Options:");
        this.buildOptionsTextBox = new Text(c, 2048);
        this.buildOptionsTextBox.setLayoutData((Object)new GridData(4, 0, true, false));
        this.updateTextBoxes();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        ++((GridLayout)parent.getLayout()).numColumns;
        Button okButton = new Button(parent, 8);
        okButton.setText(IDialogConstants.OK_LABEL);
        okButton.setFont(JFaceResources.getDialogFont());
        okButton.setData((Object)0);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (this.validateDialogEntries()) {
                    LaunchGpuVerifyDialog.this.buttonPressed((Integer)event.widget.getData());
                }
            }

            private boolean validateDialogEntries() {
                String localSizeText = LaunchGpuVerifyDialog.this.localSizeComboBox.getText();
                String globalSizeText = LaunchGpuVerifyDialog.this.globalSizeComboBox.getText();
                if (!localSizeText.matches("^[0-9]+( *[,] *[0-9]+)*$")) {
                    CoreLogging.userMessage(null, (Level)Level.WARNING, (String)"Invalid data for local work size. Must be in the form number, number...");
                    return false;
                }
                if (!globalSizeText.matches("^[0-9]+( *[,] *[0-9]+)*$")) {
                    CoreLogging.userMessage(null, (Level)Level.WARNING, (String)"Invalid data for global work size. Must be in the form number, number...");
                    return false;
                }
                @NonNull List<@NonNull Long> localSizeArray = LaunchGpuVerifyDialog.convertStringArrayToLongList(localSizeText.split(","));
                @NonNull List<@NonNull Long> globalSizeArray = LaunchGpuVerifyDialog.convertStringArrayToLongList(globalSizeText.split(","));
                if (localSizeArray.size() > 3 || globalSizeArray.size() > 3) {
                    CoreLogging.userMessage(null, (Level)Level.WARNING, (String)"Work group sizes must have between one and three dimensions.");
                    return false;
                }
                if (localSizeArray.size() != globalSizeArray.size()) {
                    CoreLogging.userMessage(null, (Level)Level.WARNING, (String)"Local and global work group sizes must have the same dimensions.");
                    return false;
                }
                int i = 0;
                while (i < localSizeArray.size()) {
                    if (localSizeArray.get(i) <= 0L || globalSizeArray.get(i) <= 0L) {
                        CoreLogging.userMessage(null, (Level)Level.WARNING, (String)"Each work group dimension must be greater than 0.");
                        return false;
                    }
                    ++i;
                }
                LaunchGpuVerifyDialog.this.buildOptions = LaunchGpuVerifyDialog.this.buildOptionsTextBox.getText();
                LaunchGpuVerifyDialog.this.localSize = ComputeWorkgroupSize.createFromLongList(localSizeArray);
                LaunchGpuVerifyDialog.this.globalSize = ComputeWorkgroupSize.createFromLongList(localSizeArray);
                return true;
            }
        });
        this.setButtonLayoutData(okButton);
    }

    public @NonNull KernelSourcePair getSelectedAsset() {
        return this.selectedAsset;
    }

    public @NonNull ComputeWorkgroupSize getLocalSize() {
        return (ComputeWorkgroupSize)NullUtils.neverNull((Object)this.localSize);
    }

    public @NonNull ComputeWorkgroupSize getGlobalSize() {
        return (ComputeWorkgroupSize)NullUtils.neverNull((Object)this.globalSize);
    }

    public @NonNull String getKernelBuildOptions() {
        return (String)NullUtils.neverNull((Object)this.buildOptions);
    }

    private static @NonNull List<@NonNull Long> convertStringArrayToLongList(String[] array) {
        ArrayList<@NonNull Long> longList = new ArrayList<Long>();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            longList.add((Long)NullUtils.neverNull((Object)Long.valueOf(element.trim())));
            ++n2;
        }
        return longList;
    }

    public static class KernelSourcePair {
        public final @NonNull ClKernelAsset kernelAsset;
        public final @NonNull String source;

        public KernelSourcePair(@NonNull ClKernelAsset kernelAsset, @NonNull String programSource) {
            this.kernelAsset = kernelAsset;
            this.source = programSource;
        }
    }
}

