/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ValueOrThrowable;
import com.arm.mgd.ui.controls.HybridModalDialog;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GoToDialog
extends HybridModalDialog<INavigationElement<?>> {
    @FXML
    private TextField numberBox;
    @FXML
    private RadioButton functionRadioBox;
    @FXML
    private Tooltip errorMessageTooltip;
    private ButtonBase okButton;
    private static final PseudoClass invalidClass = PseudoClass.getPseudoClass((String)"invalid");

    public boolean isGoToFunction() {
        return this.functionRadioBox.isSelected();
    }

    @Override
    protected void configureDialog() {
        this.numberBox.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                char[] ar = event.getCharacter().toCharArray();
                char ch = ar[event.getCharacter().toCharArray().length - 1];
                if (!Character.isDigit(ch) && ch != '\b') {
                    event.consume();
                }
            }
        });
        this.okButton = this.getButton(ButtonType.OK);
        assert (this.okButton != null);
        this.okButton.setDisable(true);
        this.okButton.setOnAction(event -> this.dispose());
        this.numberBox.textProperty().addListener((observable, oldValue, newValue) -> this.reactToInputChange((String)newValue));
        this.functionRadioBox.getToggleGroup().selectedToggleProperty().addListener((observable, oldValue, newValue) -> this.reactToInputChange(this.numberBox.getText()));
        this.reactToInputChange(this.numberBox.getText());
    }

    private void reactToInputChange(String newValue) {
        this.numberBox.pseudoClassStateChanged(invalidClass, false);
        this.okButton.setDisable(false);
        this.errorMessageTooltip.setText("Enter a function or frame number to go to.");
        try {
            this.result = GoToDialog.getNavigationElement(newValue, this.isGoToFunction());
        }
        catch (InvalidNavigationElementException e) {
            this.numberBox.pseudoClassStateChanged(invalidClass, true);
            this.okButton.setDisable(true);
            this.errorMessageTooltip.setText(e.getMessage());
        }
    }

    public static @NonNull INavigationElement<?> getNavigationElement(String numbersString, boolean isGoToFunction) throws InvalidNavigationElementException {
        @Nullable NavigationUri currentUri = CoreInstance.getNavigationManager().getActiveNavigationUri();
        if (currentUri == null) {
            throw new InvalidNavigationElementException("No trace open.");
        }
        return (INavigationElement)((ValueOrThrowable)currentUri.getModel(model -> {
            ValueOrThrowable retVal;
            try {
                FunctionCall item;
                int maxNumberAllowed;
                if (model == null) {
                    throw new InvalidNavigationElementException("No trace open.");
                }
                if (numbersString.isEmpty()) {
                    throw new InvalidNavigationElementException("You must specify a " + GoToDialog.getFrameOrFunctionString(isGoToFunction) + " number to go to.");
                }
                int parsedInt = 0;
                try {
                    parsedInt = Integer.parseInt(numbersString);
                }
                catch (NumberFormatException e) {
                    throw new InvalidNavigationElementException("The number entered is not an integer.");
                }
                int numberOfFrames = model.getFrames().count() - 1;
                int numberOfFunctions = model.getFrames().getLatestFrame().getLastFunctionIndex();
                int n = maxNumberAllowed = isGoToFunction ? numberOfFunctions : numberOfFrames;
                if (parsedInt > maxNumberAllowed) {
                    throw new InvalidNavigationElementException("The number entered is too large. Maximum " + GoToDialog.getFrameOrFunctionString(isGoToFunction) + " number is " + maxNumberAllowed + ".");
                }
                Object object = item = isGoToFunction ? model.getCallItem(parsedInt) : model.getFrames().getFrameAt(parsedInt);
                assert (item != null);
                retVal = new ValueOrThrowable((Object)item);
            }
            catch (InvalidNavigationElementException e) {
                retVal = new ValueOrThrowable((Throwable)e);
            }
            assert (retVal != null);
            return retVal;
        })).get();
    }

    private static String getFrameOrFunctionString(boolean isFunction) {
        if (isFunction) {
            return "function";
        }
        return "frame";
    }

    @Override
    protected String getTitle() {
        return "Go to function/frame";
    }

    @Override
    protected String getFXMLFilename() {
        return "/resources/dialogs/goToDialog.fxml";
    }

    @Override
    protected void setFocus() {
        this.numberBox.requestFocus();
    }

    @Override
    protected void onDispose() {
    }

    private static class InvalidNavigationElementException
    extends Exception {
        private static final long serialVersionUID = -7266889398492689836L;

        private InvalidNavigationElementException(String string) {
            super(string);
        }
    }
}

