/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.ui.dialogs.replayoverridewizard.AbstractSecondPage;
import com.arm.mgd.ui.dialogs.replayoverridewizard.ModifyPrecisionOverridePage;
import com.arm.mgd.ui.dialogs.replayoverridewizard.ModifyProgramAssetPage;
import com.arm.mgd.ui.dialogs.replayoverridewizard.SelectOverrideTypePage;
import com.arm.mgd.ui.dialogs.replayoverridewizard.SelectTextureAssetPage;
import com.arm.mgd.ui.utils.AssetUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class FrameReplayOverrideWizard
extends Wizard {
    private AbstractSecondPage<? extends IAssetItem> currentPageTwo = null;
    private final SelectOverrideTypePage page1_IntroPage;
    private final ModifyPrecisionOverridePage page2_ForcePrecisionMode;
    private final SelectTextureAssetPage page2_TextureAsset;
    private final ModifyProgramAssetPage page2_ModifyProgramAsset;
    private final Map<FrameOverrides.OverrideType, AbstractSecondPage<? extends IAssetItem>> page2Map = new HashMap<FrameOverrides.OverrideType, AbstractSecondPage<? extends IAssetItem>>();
    private final @NonNull TraceDataModel model;

    public FrameReplayOverrideWizard(@NonNull TraceStateSnapshot latestSnapshot, @NonNull TraceStateSnapshot selectedSnapshot) {
        assert (latestSnapshot.getModel() == selectedSnapshot.getModel());
        this.model = latestSnapshot.getModel();
        this.page1_IntroPage = new SelectOverrideTypePage();
        this.page2_TextureAsset = new SelectTextureAssetPage(this, "Select a texture to override:", latestSnapshot, selectedSnapshot, AssetUtils.getLabelAssetMap(GlTextureAsset.class, KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC, latestSnapshot));
        this.page2_ForcePrecisionMode = new ModifyPrecisionOverridePage(this, AbstractSecondPage.Mode.ADD, selectedSnapshot, AssetUtils.getLabelAssetMap(GlProgramAsset.class, KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC, latestSnapshot));
        this.page2_ModifyProgramAsset = new ModifyProgramAssetPage(this, AbstractSecondPage.Mode.ADD, selectedSnapshot, AssetUtils.getLabelAssetMap(GlProgramAsset.class, KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC, latestSnapshot));
        this.page2Map.put(FrameOverrides.OverrideType.FORCE_PRECISION_OVERRIDE, this.page2_ForcePrecisionMode);
        this.page2Map.put(FrameOverrides.OverrideType.TEXTURE_OVERRIDE, this.page2_TextureAsset);
        this.page2Map.put(FrameOverrides.OverrideType.PROGRAM_OVERRIDE, this.page2_ModifyProgramAsset);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page1_IntroPage);
        this.addPage((IWizardPage)this.page2_TextureAsset);
        this.addPage((IWizardPage)this.page2_ForcePrecisionMode);
        this.addPage((IWizardPage)this.page2_ModifyProgramAsset);
    }

    public boolean canFinish() {
        return this.currentPageTwo != null && this.currentPageTwo.isPageComplete();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.page1_IntroPage) {
            FrameOverrides.OverrideType secondPage = (FrameOverrides.OverrideType)this.page1_IntroPage.getSelectedValue();
            assert (secondPage != null);
            return (IWizardPage)this.page2Map.get(secondPage);
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.page1_IntroPage) {
            return null;
        }
        if (this.page2Map.containsValue(page)) {
            return this.page1_IntroPage;
        }
        assert (false) : "What page is this???";
        return null;
    }

    public IWizardPage getStartingPage() {
        return this.page1_IntroPage;
    }

    public String getWindowTitle() {
        return "New Frame Replay Override";
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        List<AbstractFrameOverride> overrides = this.currentPageTwo.createOverride();
        if (overrides == null) {
            return true;
        }
        FrameOverrides modelOverrides = this.model.getCurrentActiveOverrides();
        for (AbstractFrameOverride override : overrides) {
            if (modelOverrides.containsSimilar(override)) continue;
            assert (override != null);
            modelOverrides.add(override);
        }
        return true;
    }

    public void setPageTwo(AbstractSecondPage<? extends IAssetItem> page2) {
        this.currentPageTwo = page2;
    }

    public TraceDataModel getModel() {
        return this.model;
    }
}

