/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs;

import com.arm.mgd.ui.controls.ADBPackageVBox;
import com.arm.mgd.ui.controls.AndroidDeviceControl;
import com.arm.mgd.ui.controls.ConnectIPControl;
import com.arm.mgd.ui.controls.HybridModalWindow;
import com.arm.mgd.ui.controls.LinuxDeviceControl;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;

public class DeviceManager
extends HybridModalWindow {
    public static final @NonNull String ANDROID_HELP_RESOURCE = "/com.arm.mgd.help/com.arm.doc.101545_en/qaa1596069103945.html";
    private static final @NonNull String LINUX_HELP_RESOURCE = "/com.arm.mgd.help/com.arm.doc.101545_en/lpx1596632669367.html";
    private static final @NonNull String CONNECT_IP_HELP_RESOURCE = "/com.arm.mgd.help/com.arm.doc.101545_en/lpx1596632669367.html";
    @FXML
    private Button androidHelpButton;
    @FXML
    private VBox androidDeviceControlBox;
    @FXML
    private VBox packageControlBox;
    @FXML
    private Button linuxHelpButton;
    @FXML
    private VBox linuxDeviceControlBox;
    @FXML
    private Button connectIpHelpButton;
    @FXML
    private VBox connectIPControlBox;
    private AndroidDeviceControl androidDeviceControl;
    private LinuxDeviceControl linuxDeviceControl;
    private ADBPackageVBox adbPackageVBox;
    private ConnectIPControl connectIPControl;
    private final @NonNull InvalidationListener onConnectionOccurredListener = observable -> {
        assert (Platform.isFxApplicationThread());
        this.dispose();
    };

    @Override
    protected void configureScene() {
        this.androidDeviceControl = new AndroidDeviceControl();
        this.linuxDeviceControl = new LinuxDeviceControl();
        this.connectIPControl = new ConnectIPControl();
        this.adbPackageVBox = new ADBPackageVBox(this.androidDeviceControl.getSelectedDeviceItemProperty(), this.androidDeviceControl.getAndroidBridgeProperty());
        this.androidDeviceControlBox.getChildren().add((Object)this.androidDeviceControl);
        this.packageControlBox.getChildren().add((Object)this.adbPackageVBox);
        VBox.setVgrow((Node)this.androidDeviceControl, (Priority)Priority.ALWAYS);
        this.linuxDeviceControlBox.getChildren().add((Object)this.linuxDeviceControl);
        this.connectIPControlBox.getChildren().add((Object)this.connectIPControl);
        this.adbPackageVBox.onConnectionOccuredObservable().addListener(this.onConnectionOccurredListener);
        this.linuxDeviceControl.onConnectionOccuredObservable().addListener(this.onConnectionOccurredListener);
        this.connectIPControl.onConnectionOccuredObservable().addListener(this.onConnectionOccurredListener);
        this.androidHelpButton.setOnAction(action -> PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(ANDROID_HELP_RESOURCE));
        this.linuxHelpButton.setOnAction(action -> PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/com.arm.mgd.help/com.arm.doc.101545_en/lpx1596632669367.html"));
        this.connectIpHelpButton.setOnAction(action -> PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/com.arm.mgd.help/com.arm.doc.101545_en/lpx1596632669367.html"));
    }

    @Override
    protected void setFocus() {
        this.connectIPControlBox.requestFocus();
    }

    @Override
    protected String getTitle() {
        return "Device Manager";
    }

    @Override
    protected String getFXMLFilename() {
        return "/resources/dialogs/deviceManager.fxml";
    }

    @Override
    protected boolean isResizeable() {
        return true;
    }

    @Override
    protected @Nullable Point getMinimumSize() {
        return defaultMinimumSize;
    }

    @Override
    protected boolean closeOnEscape() {
        return true;
    }

    @Override
    protected void onDispose() {
        this.adbPackageVBox.dispose();
        this.androidDeviceControl.dispose();
        this.linuxDeviceControl.dispose();
    }
}

