/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs;

import com.arm.mgd.core.util.CoreLogging;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class CopyableMessageDialog
extends MessageDialog {
    private final String[] commands;

    public CopyableMessageDialog(String title, int dialogImageType, String msg, String @NonNull [] dialogButtonLabels, String @NonNull [] dialogButtonCommands) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, msg, dialogImageType, dialogButtonLabels, 0);
        assert (dialogButtonLabels.length == dialogButtonCommands.length);
        this.commands = dialogButtonCommands;
    }

    public CopyableMessageDialog(String title, int dialogImageType, String msg) {
        this(title, dialogImageType, msg, new String[]{"OK"}, new String[1]);
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            Text messageText = new Text(composite, this.getMessageLabelStyle() | 8);
            messageText.setBackground(composite.getBackground());
            messageText.setText(this.message);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageText);
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button[] buttons = new Button[this.getButtonLabels().length];
        int i = 0;
        while (i < this.getButtonLabels().length) {
            final String label = this.getButtonLabels()[i];
            Button button = this.createButton(parent, i, label, this.getDefaultButtonIndex() == i);
            final String command = this.commands[i];
            if (command != null) {
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                        try {
                            handlerService.executeCommand(command, null);
                        }
                        catch (Exception ex) {
                            CoreLogging.severe(null, (Throwable)ex, (String)("Unable to run command (" + command + ") for button (" + label + ")"));
                        }
                    }
                });
            }
            buttons[i] = button;
            ++i;
        }
        this.setButtons(buttons);
    }
}

