/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs;

import com.arm.mgd.ui.controls.HybridModalDialog;
import java.util.Optional;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;
import org.eclipse.jdt.annotation.NonNull;

public class ClickThroughConfirmationDialog
extends HybridModalDialog<Boolean> {
    private final @NonNull String title;
    private final @NonNull String message;
    private final boolean showCancel;
    private final boolean showDontTellAgain;
    @FXML
    private Text messageText;
    @FXML
    private CheckBox dontTellAgainCheckBox;
    @FXML
    private Label alertIcon;

    public ClickThroughConfirmationDialog(@NonNull String title, @NonNull String message, boolean showCancel, boolean showDontTellAgain) {
        this.title = title;
        this.message = message;
        this.showCancel = showCancel;
        this.showDontTellAgain = showDontTellAgain;
    }

    @Override
    public Optional<Boolean> getResult() {
        return super.getResult();
    }

    @Override
    public Optional<Boolean> showAndWaitForResult() {
        return super.showAndWaitForResult();
    }

    @Override
    protected void configureDialog() {
        Button ok = this.getButton(ButtonType.OK);
        assert (ok != null);
        Button cancel = this.getButton(ButtonType.CANCEL);
        assert (cancel != null);
        cancel.setVisible(this.showCancel);
        this.dontTellAgainCheckBox.setVisible(this.showDontTellAgain);
        this.messageText.setFontSmoothingType(FontSmoothingType.LCD);
        this.messageText.setText(this.message);
        this.alertIcon.getStyleClass().addAll((Object[])new String[]{"alert", "warning", "dialog-pane"});
        ok.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ClickThroughConfirmationDialog.this.result = ClickThroughConfirmationDialog.this.dontTellAgainCheckBox.isSelected();
                ClickThroughConfirmationDialog.this.dispose();
            }
        });
    }

    @Override
    protected String getTitle() {
        return this.title;
    }

    @Override
    protected String getFXMLFilename() {
        return "/resources/dialogs/clickThroughConfirmationDialog.fxml";
    }

    @Override
    protected void setFocus() {
        this.dontTellAgainCheckBox.requestFocus();
    }

    @Override
    protected void onDispose() {
    }
}

