/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs;

import com.arm.mgd.core.target.data.AutomatedTraceCommand;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.AutomatedTraceDialogController;
import com.arm.mgd.ui.controls.HybridModalDialog;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.util.Pair;
import javafx.util.StringConverter;

public class AutomatedTraceDialog
extends HybridModalDialog<Pair<AutomatedTraceCommand.AutomatedCommandType, List<Integer>>> {
    @FXML
    private ChoiceBox<AutomatedTraceCommand.AutomatedCommandType> commandTypeChoiceBox;
    @FXML
    private TextField frameNumbersTextField;
    @FXML
    private Tooltip errorMessageTooltip;
    private final AutomatedTraceDialogController controller = new AutomatedTraceDialogController();

    @Override
    protected void configureDialog() {
        final PseudoClass invalidClass = PseudoClass.getPseudoClass((String)"invalid");
        this.controller.isTextValidProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                AutomatedTraceDialog.this.frameNumbersTextField.pseudoClassStateChanged(invalidClass, newValue == false);
            }
        });
        this.frameNumbersTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue == null) {
                    return;
                }
                if (!newValue.matches("(,|\\d)*")) {
                    AutomatedTraceDialog.this.frameNumbersTextField.setText(oldValue);
                    return;
                }
            }
        });
        this.controller.frameNumbersTextProperty().bind((ObservableValue)this.frameNumbersTextField.textProperty());
        this.commandTypeChoiceBox.getItems().addAll((Object[])AutomatedTraceCommand.AutomatedCommandType.values());
        this.commandTypeChoiceBox.setConverter((StringConverter)new StringConverter<AutomatedTraceCommand.AutomatedCommandType>(){

            public String toString(AutomatedTraceCommand.AutomatedCommandType object) {
                return object.getDescription();
            }

            public AutomatedTraceCommand.AutomatedCommandType fromString(String string) {
                return null;
            }
        });
        this.commandTypeChoiceBox.getSelectionModel().selectFirst();
        Button okButton = this.getButton(ButtonType.OK);
        assert (okButton != null);
        okButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AutomatedTraceCommand.AutomatedCommandType type = (AutomatedTraceCommand.AutomatedCommandType)AutomatedTraceDialog.this.commandTypeChoiceBox.getSelectionModel().getSelectedItem();
                if (!$assertionsDisabled && type == null) {
                    throw new AssertionError((Object)"No selected item, something should always be selected.");
                }
                String frameNumbers = AutomatedTraceDialog.this.frameNumbersTextField.getText();
                if (!$assertionsDisabled && frameNumbers == null) {
                    throw new AssertionError((Object)"TextField returning null instead of empty string.");
                }
                try {
                    AutomatedTraceDialog.this.result = new Pair((Object)type, AutomatedTraceDialog.this.controller.getFrameNumberFromString(frameNumbers));
                    AutomatedTraceDialog.this.dispose();
                }
                catch (Exception e) {
                    CoreLogging.severe(null, (String)"Cannot convert frame numbers to integers.");
                }
            }
        });
        okButton.disableProperty().bind((ObservableValue)this.controller.isTextValidProperty().not());
        this.errorMessageTooltip.textProperty().bind((ObservableValue)this.controller.textIsNotValidReasonProperty());
    }

    @Override
    protected String getTitle() {
        return "Add Automated Trace Command";
    }

    @Override
    public String getFXMLFilename() {
        return "/resources/dialogs/automatedTraceDialog.fxml";
    }

    @Override
    protected void setFocus() {
        this.frameNumbersTextField.requestFocus();
    }

    @Override
    protected boolean isResizeable() {
        return true;
    }

    @Override
    protected void onDispose() {
    }
}

