/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs;

import com.arm.mgd.ui.controllers.ApplicationPathConfigurerDialogController;
import com.arm.mgd.ui.controls.HybridModalDialog;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import org.eclipse.jdt.annotation.NonNull;

public class ApplicationPathConfigurerDialog
extends HybridModalDialog<String> {
    @FXML
    private TextField pathField;
    @FXML
    private ProgressIndicator ioInProgressIndicator;
    @FXML
    private VBox autoDetectButtonParent;
    @FXML
    private Button autoDetectButton;
    @FXML
    private Button browseButton;
    private ButtonBase okButton;
    private final @NonNull String applicationName;
    private final @NonNull String initialPath;
    private final @NonNull String title;
    private static final PseudoClass invalidClass = PseudoClass.getPseudoClass((String)"invalid");
    private ApplicationPathConfigurerDialogController controller;

    public ApplicationPathConfigurerDialog(@NonNull String applicationName, @NonNull String initialPath, @NonNull String title) {
        this.applicationName = applicationName;
        this.initialPath = initialPath;
        this.title = title;
    }

    @Override
    protected void configureDialog() {
        this.controller = new ApplicationPathConfigurerDialogController(this.applicationName, this.initialPath);
        this.pathField.promptTextProperty().bind((ObservableValue)this.controller.pathValidityInfoProperty());
        this.pathField.textProperty().bindBidirectional((Property)this.controller.currentPathProperty());
        Tooltip errorMessageTooltip = new Tooltip();
        errorMessageTooltip.textProperty().bind((ObservableValue)this.controller.pathValidityInfoProperty());
        this.pathField.setTooltip(errorMessageTooltip);
        ContextMenuHelper.createAndSetContextMenuForTextInputField((TextInputControl)NullUtils.neverNull((Object)this.pathField), false);
        this.ioInProgressIndicator.visibleProperty().bind((ObservableValue)this.controller.ioInProgressProperty());
        this.autoDetectButton.disableProperty().bind((ObservableValue)this.controller.autoDetectEnabledProperty().not());
        Tooltip autoDetectTooltip = new Tooltip();
        autoDetectTooltip.textProperty().bind((ObservableValue)this.controller.autoDetectInfoProperty());
        Tooltip.install((Node)this.autoDetectButtonParent, (Tooltip)autoDetectTooltip);
        this.autoDetectButton.setOnAction(event -> {
            this.controller.autoDetectFromPath();
            this.pathField.requestFocus();
        });
        this.browseButton.setOnAction(event -> {
            File file = new FileChooser().showOpenDialog(this.pathField.getScene().getWindow());
            if (file != null) {
                this.pathField.setText(file.getAbsolutePath());
                this.pathField.requestFocus();
            }
        });
        this.okButton = this.getButton(ButtonType.OK);
        assert (this.okButton != null);
        this.okButton.setOnAction(event -> {
            this.result = (String)this.controller.currentPathProperty().get();
            this.dispose();
        });
        this.okButton.disabledProperty().addListener((observable, oldValue, newValue) -> {
            boolean isValid = newValue != null ? newValue : false;
            this.pathField.pseudoClassStateChanged(invalidClass, isValid);
        });
        this.okButton.disableProperty().bind((ObservableValue)this.controller.isPathToApplicationValidProperty().not());
    }

    @Override
    protected void setFocus() {
        this.pathField.requestFocus();
    }

    @Override
    protected String getTitle() {
        return this.title;
    }

    @Override
    protected String getFXMLFilename() {
        return "/resources/dialogs/applicationPathConfigurerDialog.fxml";
    }

    @Override
    protected void onDispose() {
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }
}

