/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.ui.controllers.AndroidDeviceControlItem;
import com.arm.mgd.ui.controls.AbstractAndroidDeviceControl;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class SimpleAndroidDeviceControl
extends AbstractAndroidDeviceControl {
    @FXML
    private TableColumn<@NonNull AndroidDeviceControlItem, ADBDeviceIdentifier> deviceIdColumn;
    @FXML
    private TableColumn<@NonNull AndroidDeviceControlItem, ADBDevice> deviceNameColumn;
    @FXML
    private VBox workInProgressBox;
    @FXML
    private Text workingIndicatorText;
    private static final @NonNull ReadOnlyStringWrapper UPLOADER_STATE_MESSAGE = new ReadOnlyStringWrapper();

    public SimpleAndroidDeviceControl(@NonNull ReadOnlyBooleanProperty operationInProgressProperty) {
        this.devicesTable.prefHeight(250.0);
        this.deviceIdColumn.setCellValueFactory(item -> new SimpleObjectProperty((Object)((AndroidDeviceControlItem)item.getValue()).getDeviceIdentifier()));
        this.deviceIdColumn.setCellFactory(column -> new AbstractAndroidDeviceControl.DeviceIDColumnCell());
        this.deviceNameColumn.setCellValueFactory(item -> new SimpleObjectProperty((Object)((AndroidDeviceControlItem)item.getValue()).getDevice()));
        this.deviceNameColumn.setCellFactory(column -> new AbstractAndroidDeviceControl.DeviceNameColumnCell());
        this.workInProgressBox.visibleProperty().bind((ObservableValue)operationInProgressProperty);
        this.workingIndicatorText.textProperty().bind((ObservableValue)UPLOADER_STATE_MESSAGE.getReadOnlyProperty());
        MenuItem refresh = new MenuItem("Refresh all devices");
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{refresh});
        refresh.setOnAction(event -> this.controller.fullRefreshDevices());
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull((Object)this.devicesTable), contextMenu);
        contextMenu.setOnShowing(event -> refresh.setDisable(false));
    }

    protected void setWorkIndicatorText(@NonNull AndroidDeviceControlState state) {
        UPLOADER_STATE_MESSAGE.set(state.getStateDescription());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull ReadOnlyObjectProperty<@Nullable AndroidDeviceControlItem> getSelectedItemProperty() {
        @NonNull @Nullable ReadOnlyObjectProperty property = this.devicesTable.getSelectionModel().selectedItemProperty();
        return property;
    }

    @Override
    protected @NonNull String getResourcePath() {
        return "/resources/simpleAndroidDeviceControl.fxml";
    }

    protected static interface AndroidDeviceControlState {
        public @NonNull String getStateDescription();
    }
}

