/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.chart.PieChart;
import javafx.scene.input.MouseEvent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SelectablePieChartController<T> {
    private final @NonNull ObservableList<SelectableData<T>> selectableData = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull ObservableList<// Could not load outer class - annotation placement on inner may be incorrect
    PieChart.Data> data = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull ObjectProperty<@Nullable T> selectedItem = new SimpleObjectProperty(null);
    private @Nullable Function<SelectableData<T>, ChangeListener<@Nullable T>> changelistenerFactory;
    private @Nullable BiConsumer<Node, SelectableData<T>> nodeAlterationCallBack;
    private final @NonNull Map<SelectableData<T>, ChangeListener<@Nullable T>> listeners = new HashMap<SelectableData<T>, ChangeListener<T>>();
    private @Nullable Consumer<T> onClickEvent = null;
    private @Nullable Consumer<T> onDoubleClickConsumer = null;

    public SelectablePieChartController() {
        this.selectableData.addListener(new ListChangeListener<SelectableData<T>>(){

            public void onChanged(ListChangeListener.Change<? extends SelectableData<T>> change) {
                while (change.next()) {
                    ObservableList pieVerticesData = FXCollections.observableArrayList();
                    for (final SelectableData dataAdded : change.getAddedSubList()) {
                        if (!$assertionsDisabled && dataAdded == null) {
                            throw new AssertionError((Object)"Not expecting a null data member.");
                        }
                        pieVerticesData.add((Object)dataAdded.pieChartData);
                        dataAdded.pieChartData.nodeProperty().addListener((ChangeListener)new ChangeListener<Node>(){

                            public void changed(ObservableValue<? extends Node> observableNode, Node oldNodeValue, Node newNodeValue) {
                                if (newNodeValue == null) {
                                    return;
                                }
                                if ((this).SelectablePieChartController.this.nodeAlterationCallBack != null) {
                                    (this).SelectablePieChartController.this.nodeAlterationCallBack.accept(newNodeValue, dataAdded);
                                }
                                if ((this).SelectablePieChartController.this.changelistenerFactory != null) {
                                    ChangeListener<@Nullable T> listener = (this).SelectablePieChartController.this.changelistenerFactory.apply(dataAdded);
                                    (this).SelectablePieChartController.this.selectedItem.addListener((ChangeListener)new WeakChangeListener(listener));
                                    (this).SelectablePieChartController.this.listeners.put(dataAdded, listener);
                                    listener.changed((this).SelectablePieChartController.this.selectedItem, null, (this).SelectablePieChartController.this.selectedItem.get());
                                }
                                newNodeValue.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new MouseClickEvent(dataAdded.getLinkedItem()));
                            }
                        });
                    }
                    Platform.runLater(() -> {
                        SelectablePieChartController.this.data.clear();
                        SelectablePieChartController.this.data.addAll((Collection)pieVerticesData);
                    });
                    for (SelectableData dataRemoved : change.getRemoved()) {
                        SelectablePieChartController.this.listeners.remove(dataRemoved);
                    }
                }
            }
        });
    }

    public void setOnClickConsumer(@NonNull Consumer<T> onClickEvent) {
        this.onClickEvent = onClickEvent;
    }

    public void setOnDoubleClickConsumer(@NonNull Consumer<T> onDoubleClickConsumer) {
        this.onDoubleClickConsumer = onDoubleClickConsumer;
    }

    public void setNodeAlterationCallBack(BiConsumer<Node, SelectableData<T>> nodeAlterationCallBack) {
        this.nodeAlterationCallBack = nodeAlterationCallBack;
    }

    public void setChangelistenerFactory(Function<@NonNull SelectableData<T>, ChangeListener<@Nullable T>> changelistenerFactory) {
        this.changelistenerFactory = changelistenerFactory;
    }

    public @NonNull ObservableList<// Could not load outer class - annotation placement on inner may be incorrect
    PieChart.Data> getData() {
        return this.data;
    }

    public final @NonNull ObjectProperty<@Nullable T> getSelectedItemProperty() {
        return this.selectedItem;
    }

    public void setData(ObservableList<SelectableData<T>> data) {
        Bindings.bindContent(this.selectableData, data);
    }

    public static double getSliceCenterAngle(PieChart.Data data) {
        PieChart chart = data.getChart();
        if (chart == null) {
            return 0.0;
        }
        double dataPieValue = 0.0;
        double totalPieValue = 0.0;
        boolean foundPieData = false;
        for (PieChart.Data pieData : chart.getData()) {
            if (pieData == data) {
                dataPieValue += pieData.getPieValue() / 2.0;
                foundPieData = true;
            } else if (!foundPieData) {
                dataPieValue += pieData.getPieValue();
            }
            totalPieValue += pieData.getPieValue();
        }
        boolean clockwise = chart.clockwiseProperty().get();
        double angle = Math.toRadians(dataPieValue / totalPieValue * 360.0 + 90.0 - chart.getStartAngle());
        return clockwise ? angle : -angle;
    }

    private final class MouseClickEvent
    implements EventHandler<MouseEvent> {
        private final @NonNull WeakReference<@Nullable T> linkedItem;

        public MouseClickEvent(WeakReference<T> linkedItem) {
            this.linkedItem = linkedItem;
        }

        public void handle(MouseEvent event) {
            @Nullable T item = this.linkedItem.get();
            if (item != null) {
                if (event.getClickCount() == 2) {
                    if (SelectablePieChartController.this.onDoubleClickConsumer != null) {
                        SelectablePieChartController.this.onDoubleClickConsumer.accept(item);
                    }
                } else if (SelectablePieChartController.this.onClickEvent != null) {
                    SelectablePieChartController.this.onClickEvent.accept(item);
                }
            }
        }
    }

    public static class SelectableData<E>
    implements Comparable<SelectableData<E>> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull PieChart.Data pieChartData;
        private final @NonNull WeakReference<@Nullable E> linkedItem;
        private final @NonNull String tooltip;

        public SelectableData(@NonNull String labelText, double value, @NonNull E linkedItem, @NonNull String tooltip) {
            this.pieChartData = new PieChart.Data(labelText, value);
            this.linkedItem = new WeakReference<E>(linkedItem);
            this.tooltip = tooltip;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull PieChart.Data getPieChartData() {
            return this.pieChartData;
        }

        public @NonNull WeakReference<@Nullable E> getLinkedItem() {
            return this.linkedItem;
        }

        public @NonNull String getTooltip() {
            return this.tooltip;
        }

        @Override
        public int compareTo(SelectableData<E> other) {
            return Double.compare(this.pieChartData.getPieValue(), other.pieChartData.getPieValue());
        }
    }
}

