/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.ui.controls.SelectablePieChartController;
import com.arm.mgd.utils.NullUtils;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.chart.PieChart;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SelectablePieChart<T> {
    private final @NonNull SelectablePieChartController<T> controller = new SelectablePieChartController();
    private final @NonNull PseudoClass selectedSlice = (PseudoClass)NullUtils.neverNull((Object)PseudoClass.getPseudoClass((String)"selected-slice"));

    public SelectablePieChart(@NonNull PieChart pieChart) {
        pieChart.setData(this.controller.getData());
        this.controller.setNodeAlterationCallBack(new BiConsumer<Node, SelectablePieChartController.SelectableData<T>>(){

            @Override
            public void accept(Node node, SelectablePieChartController.SelectableData<T> data) {
                Platform.runLater(() -> {
                    node.setCursor(Cursor.HAND);
                    Tooltip tooltip = new Tooltip(data.getTooltip());
                    Tooltip.install((Node)node, (Tooltip)tooltip);
                });
            }
        });
        this.controller.setChangelistenerFactory(new Function<SelectablePieChartController.SelectableData<T>, ChangeListener<T>>(){

            @Override
            public ChangeListener<@Nullable T> apply(SelectablePieChartController.SelectableData<@Nullable T> slice) {
                return new AnimationChangeListener(slice);
            }
        });
    }

    public SelectablePieChartController<T> getController() {
        return this.controller;
    }

    private void animateOut(PieChart.Data dataToAnimate) {
        Node sliceNode = dataToAnimate.getNode();
        sliceNode.pseudoClassStateChanged(this.selectedSlice, true);
        double angle = SelectablePieChartController.getSliceCenterAngle(dataToAnimate);
        double newX = Math.sin(angle) * 10.0;
        double newY = -(Math.cos(angle) * 10.0);
        sliceNode.setTranslateX(0.0);
        sliceNode.setTranslateY(0.0);
        TranslateTransition translateTransition = new TranslateTransition(Duration.millis((double)500.0), sliceNode);
        translateTransition.setByX(newX);
        translateTransition.setByY(newY);
        translateTransition.setAutoReverse(false);
        translateTransition.play();
    }

    private void animateIn(PieChart.Data dataToAnimate) {
        Node sliceNode = dataToAnimate.getNode();
        sliceNode.pseudoClassStateChanged(this.selectedSlice, false);
        double angle = SelectablePieChartController.getSliceCenterAngle(dataToAnimate);
        double newX = -Math.sin(angle) * 10.0;
        double newY = Math.cos(angle) * 10.0;
        TranslateTransition translateTransition = new TranslateTransition(Duration.millis((double)250.0), sliceNode);
        translateTransition.setByX(newX);
        translateTransition.setByY(newY);
        translateTransition.setAutoReverse(false);
        translateTransition.play();
    }

    private class AnimationChangeListener
    implements ChangeListener<T> {
        private final @NonNull SelectablePieChartController.SelectableData<@Nullable T> slice;

        public AnimationChangeListener(SelectablePieChartController.SelectableData<T> slice) {
            this.slice = slice;
        }

        public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
            if (oldValue != null && oldValue == this.slice.getLinkedItem().get()) {
                SelectablePieChart.this.animateIn(this.slice.getPieChartData());
                return;
            }
            if (newValue != null && newValue == this.slice.getLinkedItem().get()) {
                SelectablePieChart.this.animateOut(this.slice.getPieChartData());
                return;
            }
        }
    }
}

