/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.ui.FXImages;
import com.arm.mgd.ui.controllers.AndroidDeviceControlItem;
import com.arm.mgd.ui.controllers.AndroidDeviceControlItemFrameBufferConfig;
import com.arm.mgd.ui.controls.AbstractAndroidDeviceControl;
import com.arm.mgd.ui.dialogs.ProcessReplayFrameBufferConfig;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.stage.WindowEvent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ReplayDeviceListControl
extends AbstractAndroidDeviceControl {
    @FXML
    private TableColumn<@NonNull AndroidDeviceControlItem, ADBDeviceIdentifier> deviceIdColumn;
    @FXML
    private TableColumn<@NonNull AndroidDeviceControlItem, ADBDevice> deviceNameColumn;
    @FXML
    private TableColumn<@NonNull AndroidDeviceControlItem, AndroidDeviceControlItemFrameBufferConfig.Info> isConfigForcedColumn;
    private static final @NonNull StringProperty REPLAY_STATE_MESSAGE = new SimpleStringProperty(ReplayState.IDLE.description);
    private final @NonNull BooleanProperty onConnectionOccurredProperty = new SimpleBooleanProperty(false);

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public ReplayDeviceListControl() {
        this.devicesTable.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.deviceIdColumn.setCellValueFactory(item -> new SimpleObjectProperty((Object)((AndroidDeviceControlItem)item.getValue()).getDeviceIdentifier()));
        this.deviceIdColumn.setCellFactory(column -> new AbstractAndroidDeviceControl.DeviceIDColumnCell());
        this.deviceNameColumn.setCellValueFactory(item -> new SimpleObjectProperty((Object)((AndroidDeviceControlItem)item.getValue()).getDevice()));
        this.deviceNameColumn.setCellFactory(column -> new AbstractAndroidDeviceControl.DeviceNameColumnCell());
        this.isConfigForcedColumn.setCellValueFactory(item -> ((AndroidDeviceControlItem)item.getValue()).getFramebufferConfig().infoProperty());
        this.isConfigForcedColumn.setCellFactory(column -> new DeviceFramebufferConfigColumnCell());
        @NonNull SimpleListProperty selectedItems = new SimpleListProperty(this.devicesTable.getSelectionModel().getSelectedItems());
        MenuItem refresh = new MenuItem("Refresh all devices");
        MenuItem reboot = new MenuItem("Reboot the selected device(s)");
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{refresh, new SeparatorMenuItem(), new SeparatorMenuItem(), reboot});
        refresh.setOnAction(event -> this.controller.fullRefreshDevices());
        reboot.setOnAction(arg_0 -> this.lambda$7((ListProperty)selectedItems, arg_0));
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull((Object)this.devicesTable), contextMenu);
        contextMenu.setOnShowing(arg_0 -> this.lambda$8(refresh, reboot, (ListProperty)selectedItems, arg_0));
    }

    public void setReplayIndicatorText(@NonNull ReplayState state) {
        REPLAY_STATE_MESSAGE.set((Object)state.description);
    }

    public StringProperty getReplayIndicatonText() {
        return REPLAY_STATE_MESSAGE;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull ReadOnlyObjectProperty<@Nullable AndroidDeviceControlItem> getSelectedItemProperty() {
        @NonNull @Nullable ReadOnlyObjectProperty property = this.devicesTable.getSelectionModel().selectedItemProperty();
        return property;
    }

    public @NonNull Observable onConnectionOccuredObservable() {
        return this.onConnectionOccurredProperty;
    }

    @Override
    protected @NonNull String getResourcePath() {
        return "/resources/replayDeviceListControl.fxml";
    }

    private /* synthetic */ void lambda$7(ListProperty listProperty, ActionEvent event) {
        this.controller.reboot((List<AndroidDeviceControlItem>)listProperty);
    }

    private /* synthetic */ void lambda$8(MenuItem menuItem, MenuItem menuItem2, ListProperty listProperty, WindowEvent event) {
        menuItem.setDisable(false);
        menuItem2.setDisable(!this.controller.canReboot((List<AndroidDeviceControlItem>)listProperty));
    }

    private class DeviceFramebufferConfigColumnCell
    extends TableCell<AndroidDeviceControlItem, AndroidDeviceControlItemFrameBufferConfig.Info> {
        private final @NonNull Button forceConfigButton = new Button(null, (Node)new ImageView(FXImages.TRACE_CONFIG));
        private final @NonNull Button resetConfigButton = new Button(null, (Node)new ImageView(FXImages.TRACE_CONFIG_GO));
        private final @NonNull StackPane iconStack = new StackPane(new Node[]{this.forceConfigButton, this.resetConfigButton});
        private final @NonNull Tooltip tooltip = new Tooltip();

        private DeviceFramebufferConfigColumnCell() {
            this.setGraphic((Node)this.iconStack);
            this.setAlignment(Pos.CENTER);
            this.forceConfigButton.setPadding(new Insets(3.0));
            this.forceConfigButton.setTooltip(new Tooltip("Force Framebuffer Configuration"));
            this.resetConfigButton.setPadding(new Insets(3.0));
            this.resetConfigButton.setTooltip(new Tooltip("Reset Framebuffer Configuration"));
        }

        private void setAllIconsNotVisible() {
            this.iconStack.getChildren().forEach(child -> child.setVisible(false));
        }

        protected void updateItem(AndroidDeviceControlItemFrameBufferConfig.Info item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setTooltip(null);
                this.iconStack.setVisible(false);
            } else {
                this.setTooltip(this.tooltip);
                this.forceConfigButton.setOnAction(event -> {
                    this.getTableView().getSelectionModel().select(this.getTableRow().getIndex());
                    new ProcessReplayFrameBufferConfig(item.getConfig()).showAndWait();
                });
                this.resetConfigButton.setOnAction(event -> {
                    this.getTableView().getSelectionModel().select(this.getTableRow().getIndex());
                    new ProcessReplayFrameBufferConfig(item.getConfig()).showAndWait();
                });
                this.tooltip.setText(item.getInfo());
                this.iconStack.setVisible(true);
                this.setAllIconsNotVisible();
                AndroidDeviceControlItemFrameBufferConfig.FrameBufferConfigStatus status = item.getStatus();
                switch (status) {
                    case FB_FORCED: {
                        this.resetConfigButton.setVisible(true);
                        break;
                    }
                    case VP_FORCED: {
                        this.resetConfigButton.setVisible(true);
                        break;
                    }
                    case FB_VP_FORCED: {
                        this.resetConfigButton.setVisible(true);
                        break;
                    }
                    case NOT_FORCED: {
                        this.forceConfigButton.setVisible(true);
                        break;
                    }
                    case DISCONNECTED: {
                        this.forceConfigButton.setDisable(true);
                        this.resetConfigButton.setDisable(true);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)status);
                    }
                }
            }
        }
    }

    public static enum ReplayState {
        MARSHALLING("Marshalling trace..."),
        UPLOADING("Uploading trace to device..."),
        REPLAYING("Replaying the trace on device..."),
        DONE("Done."),
        IDLE("");

        public final @NonNull String description;

        private ReplayState(String description) {
            this.description = description;
        }
    }
}

