/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.core.target.data.interceptorconfig.ISelectableResource;
import com.arm.mgd.core.target.data.interceptorconfig.InterceptorConfig;
import com.arm.mgd.core.target.data.interceptorconfig.cl.ClConfig;
import com.arm.mgd.core.target.data.interceptorconfig.cl.ClResource;
import com.arm.mgd.core.target.data.interceptorconfig.gles.GlesConfig;
import com.arm.mgd.core.target.data.interceptorconfig.gles.GlesResource;
import com.arm.mgd.core.target.data.interceptorconfig.vulkan.VulkanConfig;
import com.arm.mgd.core.target.data.interceptorconfig.vulkan.VulkanResource;
import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.core.target.io.ProcessConfigHistory;
import com.arm.mgd.core.target.io.ProcessConfigPreset;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.ProcessConfigController;
import com.arm.mgd.ui.targetconn.LiveConnectionSettings;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProcessConfigControl
extends VBox {
    private static final @NonNull List<@NonNull ResourceDisplayInfo> CL_RESOURCE_TYPES = new ArrayList<ResourceDisplayInfo>();
    private static final @NonNull List<@NonNull ResourceDisplayInfo> GL_RESOURCE_TYPES = new ArrayList<ResourceDisplayInfo>();
    private static final @NonNull List<@NonNull ResourceDisplayInfo> VK_RESOURCE_TYPES = new ArrayList<ResourceDisplayInfo>();
    @FXML
    private ComboBox<ProcessConfigPreset> comboBox;
    @FXML
    private Text selectionDescription;
    @FXML
    private Text configurationInfo;
    @FXML
    private GridPane controlsPane;
    @FXML
    private VBox clOptionBox;
    @FXML
    private VBox glOptionBox;
    @FXML
    private VBox vkOptionBox;
    @FXML
    private Button setAsDefaultButton;
    @FXML
    private Button applyButton;
    private final @NonNull CheckBox sendOutputsBox;
    private final @NonNull BooleanProperty controlsDisabledProperty = new SimpleBooleanProperty();
    private final @NonNull ObjectProperty<@Nullable ProcessConfig> activeConfigProperty = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable ProcessConfig> selectedConfigProperty = new SimpleObjectProperty();
    private final @NonNull StringProperty activeConfigInformationProperty = new SimpleStringProperty();
    private final @NonNull StringProperty applyInformationProperty = new SimpleStringProperty();
    private final @NonNull BooleanProperty isSelectedConfigSameAsDefaultProperty = new SimpleBooleanProperty();
    private boolean isInsideSelectedConfigChange = false;
    private final @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ISelectableResource.SelectableResourceType, CheckBox> clResouceTypeToCheckBoxMap;
    private final @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ISelectableResource.SelectableResourceType, CheckBox> glResourceTypeToCheckBoxMap;
    private final @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ISelectableResource.SelectableResourceType, CheckBox> vkResourceTypeToCheckBoxMap;

    static {
        CL_RESOURCE_TYPES.add(new ResourceDisplayInfo(ISelectableResource.SelectableResourceType.CL_PROGRAM_ASSET_SOURCE, true, "Program sources", "Send program sources."));
        CL_RESOURCE_TYPES.add(new ResourceDisplayInfo(ISelectableResource.SelectableResourceType.CL_EXPLICIT_MEMORY_ASSET, true, "Explicit memory", "Send changes to buffer contents triggered by explicit memory upload functions."));
        CL_RESOURCE_TYPES.add(new ResourceDisplayInfo(ISelectableResource.SelectableResourceType.CL_IMPLICIT_MEMORY_ASSET, false, "Implicit memory", "Send changes to buffer contents triggered by writes to mapped memory."));
        GL_RESOURCE_TYPES.add(new ResourceDisplayInfo(ISelectableResource.SelectableResourceType.GL_SHADER_ASSET_SOURCE, true, "Shader sources", "Send shader sources."));
        GL_RESOURCE_TYPES.add(new ResourceDisplayInfo(ISelectableResource.SelectableResourceType.GL_SHADER_ASSET_UNIFORM, true, "Shader uniforms", "Send changes to shader uniform contents."));
        GL_RESOURCE_TYPES.add(new ResourceDisplayInfo(ISelectableResource.SelectableResourceType.GL_SHADER_ASSET_BINARY, true, "Shader binaries", "Send binary shaders."));
        GL_RESOURCE_TYPES.add(new ResourceDisplayInfo(ISelectableResource.SelectableResourceType.GL_TEXTURE_ASSET, true, "Texture contents", "Send changes to texture contents triggered by explicit texture upload functions."));
        GL_RESOURCE_TYPES.add(new ResourceDisplayInfo(ISelectableResource.SelectableResourceType.GL_EXPLICIT_BUFFER_ASSET, true, "Explicit buffers", "Send changes to buffer contents triggered by explicit buffer upload functions."));
        GL_RESOURCE_TYPES.add(new ResourceDisplayInfo(ISelectableResource.SelectableResourceType.GL_IMPLICIT_BUFFER_ASSET, true, "Implicit buffers", "Send changes to buffer contents triggered by writes to mapped memory."));
        VK_RESOURCE_TYPES.add(new ResourceDisplayInfo(ISelectableResource.SelectableResourceType.VK_SHADER_ASSET_BINARY, true, "Shader binaries", "Send binary shaders."));
        VK_RESOURCE_TYPES.add(new ResourceDisplayInfo(ISelectableResource.SelectableResourceType.VK_IMPLICIT_DEVICE_MEMORY_ASSET, true, "Implicit memory", "Send changes to device memory contents triggered by writes to mapped memory."));
        assert (CL_RESOURCE_TYPES.size() == ClConfig.EVERYTHING_SELECTED.getChildren().size());
        assert (GL_RESOURCE_TYPES.size() == GlesConfig.EVERYTHING_SELECTED.getChildren().size());
        assert (VK_RESOURCE_TYPES.size() == VulkanConfig.EVERYTHING_SELECTED.getChildren().size());
    }

    public ProcessConfigControl(@NonNull ProcessConfigController controller) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/resources/processConfigControl.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
        }
        this.clResouceTypeToCheckBoxMap = this.addResourceCheckBoxes(CL_RESOURCE_TYPES, this.clOptionBox);
        this.glResourceTypeToCheckBoxMap = this.addResourceCheckBoxes(GL_RESOURCE_TYPES, this.glOptionBox);
        this.vkResourceTypeToCheckBoxMap = this.addResourceCheckBoxes(VK_RESOURCE_TYPES, this.vkOptionBox);
        this.sendOutputsBox = new CheckBox("Output buffers");
        this.sendOutputsBox.selectedProperty().addListener(invalidated -> this.onCheckBoxStateChange());
        this.sendOutputsBox.setTooltip(new Tooltip("Send changes to buffer contents triggered by compute shader invocations or transform feedback."));
        this.glOptionBox.getChildren().add((Object)this.sendOutputsBox);
        this.comboBox.setItems(FXCollections.observableArrayList((Collection)ProcessConfigPreset.PRESETS));
        this.comboBox.setPromptText("Custom");
        this.comboBox.setCellFactory(listView -> new ProcessConfigPresetListCell());
        this.comboBox.setButtonCell((ListCell)new ProcessConfigPresetListCell());
        this.comboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (this.isInsideSelectedConfigChange) {
                return;
            }
            if (newValue != null) {
                this.selectedConfigProperty.set((Object)newValue.getConfig());
            }
        });
        this.selectedConfigProperty.addListener((observable, oldValue, newValue) -> {
            this.isInsideSelectedConfigChange = true;
            if (newValue != null) {
                ProcessConfigPreset preset = ProcessConfigPreset.getPresetForConfig((ProcessConfig)newValue);
                this.selectionDescription.setText(preset != null ? preset.getDescription() : "Trace using a custom configuration.");
                this.comboBox.getSelectionModel().select((Object)preset);
                this.setCheckBoxState((ProcessConfig)newValue);
                this.isSelectedConfigSameAsDefaultProperty.set(newValue.equals((Object)LiveConnectionSettings.getDefaultProcessConfig()));
            }
            this.isInsideSelectedConfigChange = false;
        });
        this.controlsPane.disableProperty().bind((ObservableValue)this.controlsDisabledProperty);
        this.comboBox.disableProperty().bind((ObservableValue)this.controlsDisabledProperty);
        this.applyButton.disableProperty().bind((ObservableValue)this.controlsDisabledProperty.or((ObservableBooleanValue)this.activeConfigProperty.isEqualTo(this.selectedConfigProperty)));
        this.setAsDefaultButton.disableProperty().bind((ObservableValue)this.controlsDisabledProperty.or((ObservableBooleanValue)this.isSelectedConfigSameAsDefaultProperty));
        this.applyButton.setOnAction(event -> {
            @Nullable ProcessConfig config = (ProcessConfig)this.selectedConfigProperty.get();
            if (config != null) {
                controller.setActiveProcessConfiguration(config);
            }
        });
        this.setAsDefaultButton.setOnAction(event -> {
            @Nullable ProcessConfig config = (ProcessConfig)this.selectedConfigProperty.get();
            if (config != null) {
                LiveConnectionSettings.setDefaultProcessConfig(config);
                this.isSelectedConfigSameAsDefaultProperty.set(true);
            }
        });
        this.applyButton.disabledProperty().addListener((observable, oldValue, newValue) -> this.onApplyButtonDisabledChange((boolean)newValue));
        this.onApplyButtonDisabledChange(this.applyButton.disabledProperty().get());
        controller.activeProcessConfigProperty().addListener((observable, oldValue, newValue) -> this.onConfigurationInfoChange((ProcessConfigController.ProcessConfigInfo)newValue));
        this.onConfigurationInfoChange((ProcessConfigController.ProcessConfigInfo)controller.activeProcessConfigProperty().get());
    }

    private void onConfigurationInfoChange(@NonNull ProcessConfigController.ProcessConfigInfo configInfo) {
        String applyDetails;
        String configurationDetails;
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ProcessConfigHistory.Range historyRange = configInfo.activeProcessConfigRange;
        if (historyRange != null) {
            StringBuilder sb = new StringBuilder("This configuration was active from Function Call ");
            sb.append(historyRange.processConfigStart.functionCallIndexFromInclusive);
            ProcessConfigHistory end = historyRange.processConfigEnd;
            if (end != null) {
                sb.append(" to Function Call ").append(end.functionCallIndexFromInclusive);
            }
            sb.append(".");
            configurationDetails = sb.toString();
            applyDetails = "Apply the changes to update the trace configuration of the currently selected process.";
        } else {
            configurationDetails = "This configuration will be applied to all newly created processes in this trace.\nThe configuration can be changed at any time.";
            applyDetails = "Apply the changes to make newly created processes in this trace use this configuration.\nThe configuration can be changed at any time.";
        }
        this.controlsDisabledProperty.set(!configInfo.isProcessConfigChangeable);
        this.activeConfigProperty.set((Object)configInfo.activeProcessConfig);
        this.selectedConfigProperty.set((Object)configInfo.activeProcessConfig);
        this.activeConfigInformationProperty.set((Object)configurationDetails);
        this.applyInformationProperty.set((Object)applyDetails);
    }

    private @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ISelectableResource.SelectableResourceType, CheckBox> addResourceCheckBoxes(@NonNull List<@NonNull ResourceDisplayInfo> resourceDisplayInfos, VBox optionBox) {
        HashMap<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ISelectableResource.SelectableResourceType, CheckBox> map = new HashMap<ISelectableResource.SelectableResourceType, CheckBox>();
        resourceDisplayInfos.forEach(type -> {
            CheckBox box = new CheckBox(type.name);
            map.put(type.type, box);
            box.selectedProperty().addListener(invalidated -> this.onCheckBoxStateChange());
            box.setTooltip(new Tooltip(type.description));
            if (type.shouldShow) {
                optionBox.getChildren().add((Object)box);
            }
        });
        return map;
    }

    private void onCheckBoxStateChange() {
        if (this.isInsideSelectedConfigChange) {
            return;
        }
        ArrayList<@NonNull E> clResources = new ArrayList();
        ArrayList<@NonNull E> glResources = new ArrayList();
        ArrayList<@NonNull E> vkResources = new ArrayList();
        this.clResouceTypeToCheckBoxMap.forEach((key, value) -> {
            boolean bl = clResources.add(new ClResource(key, value.isSelected()));
        });
        this.glResourceTypeToCheckBoxMap.forEach((key, value) -> {
            boolean bl = glResources.add(new GlesResource(key, value.isSelected()));
        });
        this.vkResourceTypeToCheckBoxMap.forEach((key, value) -> {
            boolean bl = vkResources.add(new VulkanResource(key, value.isSelected()));
        });
        InterceptorConfig interceptorConfig = new InterceptorConfig(new ClConfig(clResources, false), new GlesConfig(glResources, false), new VulkanConfig(vkResources, false));
        ProcessConfig config = new ProcessConfig(interceptorConfig, this.sendOutputsBox.isSelected());
        this.selectedConfigProperty.set((Object)config);
    }

    private void setCheckBoxState(@NonNull ProcessConfig config) {
        config.interceptorConfig.getClConfig().getChildren().forEach(item -> ((CheckBox)NullUtils.neverNull((Object)this.clResouceTypeToCheckBoxMap.get(item.getSelectableResourceType()))).setSelected(item.isSelectedForCapture()));
        config.interceptorConfig.getGlesConfig().getChildren().forEach(item -> ((CheckBox)NullUtils.neverNull((Object)this.glResourceTypeToCheckBoxMap.get(item.getSelectableResourceType()))).setSelected(item.isSelectedForCapture()));
        config.interceptorConfig.getVulkanConfig().getChildren().forEach(item -> ((CheckBox)NullUtils.neverNull((Object)this.vkResourceTypeToCheckBoxMap.get(item.getSelectableResourceType()))).setSelected(item.isSelectedForCapture()));
        this.sendOutputsBox.setSelected(config.outputBuffersEnabled);
    }

    private void onApplyButtonDisabledChange(boolean isDisabled) {
        @NonNull StringProperty stringProperty = isDisabled ? this.activeConfigInformationProperty : this.applyInformationProperty;
        this.configurationInfo.textProperty().bind((ObservableValue)stringProperty);
    }

    private static class ProcessConfigPresetListCell
    extends ListCell<ProcessConfigPreset> {
        private ProcessConfigPresetListCell() {
        }

        protected void updateItem(ProcessConfigPreset item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setText(item != null ? item.getName() : null);
        }
    }

    private static class ResourceDisplayInfo {
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ISelectableResource.SelectableResourceType type;
        private boolean shouldShow;
        private final @NonNull String name;
        private final @NonNull String description;

        private ResourceDisplayInfo(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ISelectableResource.SelectableResourceType type, boolean shouldShow, @NonNull String name, @NonNull String description) {
            this.type = type;
            this.shouldShow = shouldShow;
            this.name = name;
            this.description = description;
        }
    }
}

