/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.core.target.io.ProcessConfigPreset;
import com.arm.mgd.ui.FXImages;
import com.arm.mgd.ui.controllers.ProcessConfigController;
import com.arm.mgd.ui.controls.ProcessConfigControl;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import org.controlsfx.control.PopOver;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProcessConfigBar
extends HBox {
    private final @NonNull ToggleButton button = new ToggleButton();
    private final @NonNull PopOver popOver;

    public ProcessConfigBar(@NonNull ProcessConfigController controller) {
        this.popOver = new PopOver((Node)new ProcessConfigControl(controller));
        this.getChildren().add((Object)this.button);
        this.button.setPrefHeight(23.0);
        this.button.setPrefWidth(225.0);
        this.button.setPadding(new Insets(1.0));
        this.button.setGraphic((Node)new ImageView(FXImages.TRACE_CONFIG));
        this.button.setTooltip(new Tooltip("Show the trace configuration control"));
        this.button.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                if (!this.popOver.isShowing()) {
                    this.popOver.show((Node)this.button);
                }
            } else {
                this.popOver.hide();
            }
        });
        this.popOver.showingProperty().addListener((observable, oldValue, newValue) -> this.button.setSelected(newValue.booleanValue()));
        this.popOver.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.popOver.hide();
            }
        });
        this.popOver.setDetachable(false);
        this.popOver.setArrowLocation(PopOver.ArrowLocation.TOP_CENTER);
        controller.activeProcessConfigProperty().addListener((observable, oldValue, newValue) -> this.onActiveProcessConfigChange((ProcessConfigController.ProcessConfigInfo)newValue));
        this.onActiveProcessConfigChange((ProcessConfigController.ProcessConfigInfo)controller.activeProcessConfigProperty().get());
    }

    private void onActiveProcessConfigChange(@NonNull ProcessConfigController.ProcessConfigInfo configInfo) {
        assert (Platform.isFxApplicationThread());
        @Nullable ProcessConfig config = configInfo.activeProcessConfig;
        if (config == null) {
            this.button.setDisable(true);
            this.button.setText("No active connection");
            if (this.popOver.isShowing()) {
                this.popOver.hide();
            }
        } else {
            this.button.setDisable(false);
            this.button.setText("Trace Config: " + ProcessConfigPreset.getPresetNameForConfig((ProcessConfig)config));
        }
    }
}

