/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.FXImages;
import com.arm.mgd.ui.controllers.LinuxDevice;
import com.arm.mgd.ui.controllers.LinuxDeviceControlController;
import com.arm.mgd.ui.targetconn.LiveTargetConnection;
import com.arm.mgd.utils.VersionProperties;
import java.io.IOException;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.eclipse.jdt.annotation.NonNull;

public class LinuxDeviceControl
extends StackPane {
    @FXML
    private TableView<@NonNull LinuxDevice> devicesTable;
    @FXML
    private TableColumn<@NonNull LinuxDevice, LinuxDevice.ConnectionStatus> isConnectedColumn;
    @FXML
    private TableColumn<@NonNull LinuxDevice, String> identifierColumn;
    @FXML
    private TableColumn<@NonNull LinuxDevice, String> protocolVersionColumn;
    @FXML
    private TableColumn<@NonNull LinuxDevice, String> glVendorColumn;
    @FXML
    private TableColumn<@NonNull LinuxDevice, String> glRendererColumn;
    @FXML
    private TableColumn<@NonNull LinuxDevice, String> glVersionColumn;
    @FXML
    private VBox blockingUpdateProgressBox;
    @FXML
    private VBox blockingErrorBox;
    @FXML
    private Label errorLabel;
    private LinuxDeviceControlController controller;
    private final @NonNull BooleanProperty onConnectionOccurredProperty = new SimpleBooleanProperty(false);
    private final @NonNull Consumer<@NonNull LiveTargetConnection> onSuccessfulConnectionCallback = connection -> Platform.runLater(() -> this.onConnectionOccurredProperty.set(!this.onConnectionOccurredProperty.get()));

    public LinuxDeviceControl() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/resources/linuxDeviceControl.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
        }
        this.controller = new LinuxDeviceControlController();
        this.devicesTable.itemsProperty().bind(this.controller.linuxDevicesProperty());
        this.devicesTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.devicesTable.setPlaceholder((Node)new Label("No devices found"));
        this.devicesTable.setRowFactory(table -> new DoubleClickToConnectRow());
        this.devicesTable.focusTraversableProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)this.devicesTable.getItems()));
        this.isConnectedColumn.setCellValueFactory(item -> ((LinuxDevice)item.getValue()).connectionStatusProperty());
        this.isConnectedColumn.setCellFactory(column -> new ConnectionStatusCell());
        this.identifierColumn.setCellValueFactory(item -> ((LinuxDevice)item.getValue()).identifierProperty());
        this.identifierColumn.setCellFactory(column -> new TooltipStringColumnCell());
        this.protocolVersionColumn.setCellValueFactory(item -> ((LinuxDevice)item.getValue()).daemonProtocolVersionProperty());
        this.protocolVersionColumn.setCellFactory(column -> new TooltipStringColumnCell());
        this.glVendorColumn.setCellValueFactory(item -> ((LinuxDevice)item.getValue()).glVendorProperty());
        this.glVendorColumn.setCellFactory(column -> new TooltipStringColumnCell());
        this.glRendererColumn.setCellValueFactory(item -> ((LinuxDevice)item.getValue()).glRendererProperty());
        this.glRendererColumn.setCellFactory(column -> new TooltipStringColumnCell());
        this.glVersionColumn.setCellValueFactory(item -> ((LinuxDevice)item.getValue()).glVersionProperty());
        this.glVersionColumn.setCellFactory(column -> new TooltipStringColumnCell());
        this.blockingUpdateProgressBox.visibleProperty().bind((ObservableValue)this.controller.initializationInProgressProperty());
        this.controller.statusInfoProperty().addListener((observable, oldValue, newValue) -> this.onStatusChange((LinuxDeviceControlController.StatusInfo)newValue));
        this.onStatusChange((LinuxDeviceControlController.StatusInfo)this.controller.statusInfoProperty().get());
    }

    public void dispose() {
        this.controller.dispose();
        this.controller = null;
    }

    private void onStatusChange(@NonNull LinuxDeviceControlController.StatusInfo statusInfo) {
        String exceptionMessage;
        boolean showErrorBox;
        switch (statusInfo.status) {
            case RETRYING: 
            case GIVENUP: {
                showErrorBox = true;
                exceptionMessage = statusInfo.statusException != null ? statusInfo.statusException.getMessage() : null;
                break;
            }
            case RUNNING: {
                showErrorBox = false;
                exceptionMessage = null;
                break;
            }
            default: {
                throw new AssertionError(statusInfo.status);
            }
        }
        this.blockingErrorBox.visibleProperty().set(showErrorBox);
        if (showErrorBox) {
            @NonNull StringBuilder sb = new StringBuilder("There was an error detecting Linux devices");
            if (exceptionMessage != null) {
                sb.append(": ").append(exceptionMessage);
            } else {
                sb.append(".");
            }
            sb.append(System.lineSeparator()).append(System.lineSeparator());
            sb.append("Make sure no other instances of " + VersionProperties.FULL_PRODUCT_NAME + " have this window open, and ensure that port 5003 is not currently in use.");
            this.errorLabel.setText(sb.toString());
        }
    }

    public @NonNull Observable onConnectionOccuredObservable() {
        return this.onConnectionOccurredProperty;
    }

    private class ConnectionStatusCell
    extends TableCell<LinuxDevice, LinuxDevice.ConnectionStatus> {
        private final @NonNull Button connectButton = new Button("Start Capture", (Node)new ImageView(FXImages.CONNECT));
        private final @NonNull Button disconnectButton = new Button("Disconnect", (Node)new ImageView(FXImages.DISCONNECT));
        private final @NonNull ProgressIndicator indicator = new ProgressIndicator(-1.0);
        private final @NonNull StackPane iconStack = new StackPane(new Node[]{this.connectButton, this.disconnectButton, this.indicator});
        private Tooltip tooltip = new Tooltip();

        private ConnectionStatusCell() {
            this.setGraphic((Node)this.iconStack);
            this.setAlignment(Pos.CENTER);
            this.indicator.setPrefSize(16.0, 16.0);
            this.indicator.setMouseTransparent(true);
            this.connectButton.setPadding(new Insets(3.0));
            this.connectButton.setTooltip(new Tooltip("Connect to this device"));
            this.disconnectButton.setPadding(new Insets(3.0));
            this.disconnectButton.setTooltip(new Tooltip("Disconnect from this device"));
        }

        private void setAllIconsNotVisible() {
            this.iconStack.getChildren().forEach(child -> child.setVisible(false));
        }

        protected void updateItem(LinuxDevice.ConnectionStatus item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setTooltip(null);
                this.iconStack.setVisible(false);
            } else {
                this.setTooltip(null);
                @NonNull LinuxDevice device = (LinuxDevice)this.getTableView().getItems().get(this.getIndex());
                this.connectButton.setOnAction(event -> device.connect(LinuxDeviceControl.this.onSuccessfulConnectionCallback));
                this.disconnectButton.setOnAction(event -> device.disconnect());
                this.iconStack.setVisible(true);
                this.setAllIconsNotVisible();
                switch (item) {
                    case OPERATION_IN_PROGRESS: {
                        this.indicator.setVisible(true);
                        break;
                    }
                    case CONNECTED: {
                        this.disconnectButton.setVisible(true);
                        break;
                    }
                    case DISCONNECTED_AND_CAN_CONNECT: {
                        this.connectButton.setVisible(true);
                        this.connectButton.setDisable(false);
                        break;
                    }
                    case DISCONNECTED_AND_CANT_CONNECT_WRONG_PROTOCOL_VERSION: {
                        this.connectButton.setVisible(true);
                        this.connectButton.setDisable(true);
                        this.setTooltip(this.tooltip);
                        this.tooltip.setText("This device is using a daemon with a different protocol version");
                        break;
                    }
                    case CONNECTED_TO_ANOTHER_MGD: {
                        this.connectButton.setVisible(true);
                        this.connectButton.setDisable(true);
                        this.setTooltip(this.tooltip);
                        this.tooltip.setText("This device is already connected to another " + VersionProperties.FULL_PRODUCT_NAME);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)item);
                    }
                }
            }
        }
    }

    private class DoubleClickToConnectRow
    extends TableRow<LinuxDevice> {
        private DoubleClickToConnectRow() {
            this.setOnMouseClicked(event -> {
                LinuxDevice item = (LinuxDevice)this.getItem();
                if (item != null && event.getClickCount() == 2) {
                    switch ((LinuxDevice.ConnectionStatus)((Object)((Object)item.connectionStatusProperty().get()))) {
                        case CONNECTED: {
                            item.disconnect();
                            break;
                        }
                        case DISCONNECTED_AND_CAN_CONNECT: {
                            item.connect(LinuxDeviceControl.this.onSuccessfulConnectionCallback);
                            break;
                        }
                    }
                }
            });
        }
    }

    private static class TooltipStringColumnCell
    extends TableCell<LinuxDevice, String> {
        private final @NonNull Tooltip tooltip = new Tooltip();

        private TooltipStringColumnCell() {
            this.setAlignment(Pos.CENTER_LEFT);
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || empty) {
                this.setText(null);
                this.setTooltip(null);
            } else {
                this.setText(item);
                this.setTooltip(this.tooltip);
                this.tooltip.setText(item);
            }
        }
    }
}

