/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.Images;
import com.arm.mgd.ui.controls.FXCanvasWithMouseWheelFix;
import com.arm.mgd.utils.OSUtils;
import java.io.IOException;
import javafx.application.Platform;
import javafx.embed.swt.FXCanvas;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Window;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class HybridModalWindow {
    @FXML
    private Parent root;
    private Shell shell;
    private FXCanvas canvas;
    private @Nullable ShellListener listener = null;
    protected static final @NonNull Point defaultMinimumSize = new Point(300, 200);

    public void showAndWait() {
        assert (Platform.isFxApplicationThread());
        try {
            this.shell = this.addSceneToShell();
            this.updateSize();
            Display display = this.shell.getDisplay();
            Shell currentShell = display.getActiveShell();
            if (currentShell != null) {
                Point currentShellLocation = currentShell.getLocation();
                Point currentShellSize = currentShell.getSize();
                int centerX = currentShellLocation.x + currentShellSize.x / 2;
                int centerY = currentShellLocation.y + currentShellSize.y / 2;
                Point newShellSize = this.shell.getSize();
                int newShellLocationX = centerX - newShellSize.x / 2;
                int newShellLocationY = centerY - newShellSize.y / 2;
                this.shell.setLocation(newShellLocationX, newShellLocationY);
            }
            this.shell.open();
            this.alignShellComponents();
            while (!this.shell.isDisposed()) {
                if (OSUtils.OS != OSUtils.OSType.MAC) {
                    this.shell.setActive();
                }
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            this.onDispose();
        }
    }

    protected abstract void configureScene();

    protected abstract void setFocus();

    protected abstract String getTitle();

    protected abstract String getFXMLFilename();

    protected abstract void onDispose();

    protected final void updateSize() {
        if (this.shell != null) {
            this.shell.setSize(this.shell.computeSize(-1, -1, true));
        }
    }

    protected void dispose() {
        if (this.shell != null) {
            this.shell.dispose();
        }
    }

    protected boolean isResizeable() {
        return false;
    }

    protected @Nullable Point getMinimumSize() {
        return null;
    }

    protected boolean closeOnEscape() {
        return false;
    }

    private Shell addSceneToShell() {
        int style = 67680;
        if (this.isResizeable()) {
            style |= 0x10;
        }
        this.shell = new Shell(PlatformUI.getWorkbench().getDisplay(), style);
        this.shell.setText(this.getTitle());
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setImages(Images.MGD_ICONS);
        Point minimumSize = this.getMinimumSize();
        if (minimumSize != null) {
            this.shell.setMinimumSize(minimumSize);
        }
        if (this.listener != null) {
            this.setShellListener(this.listener);
        }
        this.canvas = new FXCanvasWithMouseWheelFix((Composite)this.shell, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Scene scene = this.getScene();
                if (scene == null) {
                    return new Point(0, 0);
                }
                Window window = scene.getWindow();
                if (window == null) {
                    return new Point(0, 0);
                }
                window.sizeToScene();
                int width = (int)scene.getWidth();
                int height = (int)scene.getHeight();
                return new Point(width, height);
            }
        };
        this.canvas.setScene(this.createScene());
        this.setFocus();
        return this.shell;
    }

    private Scene createScene() {
        this.configureRoot();
        this.configureScene();
        return new Scene(this.root);
    }

    private void configureRoot() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource(this.getFXMLFilename()));
        fxmlLoader.setController((Object)this);
        try {
            this.root = (Parent)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
        }
        this.root.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (this.closeOnEscape() && KeyCode.ESCAPE.equals((Object)event.getCode())) {
                this.dispose();
            }
        });
    }

    private void alignShellComponents() {
        if (this.shell != null) {
            Point old = this.shell.getLocation();
            this.shell.setLocation(new Point(old.x + 1, old.y));
            this.shell.setLocation(old);
        }
    }

    protected void setShellListener(@NonNull ShellListener listener) {
        this.listener = listener;
        if (this.shell != null) {
            this.shell.addShellListener(listener);
        }
    }
}

