/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.ui.controls.HybridModalWindow;
import java.util.Optional;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import org.eclipse.jdt.annotation.Nullable;

public abstract class HybridModalDialog<R>
extends HybridModalWindow {
    @FXML
    private DialogPane dialogPane;
    protected @Nullable R result = null;

    public Optional<R> showAndWaitForResult() {
        this.showAndWait();
        return this.getResult();
    }

    public Optional<R> getResult() {
        return Optional.ofNullable(this.result);
    }

    protected abstract void configureDialog();

    @Override
    protected final void configureScene() {
        this.configureCancelButton();
        this.configureDialog();
    }

    protected @Nullable Button getButton(ButtonType buttonType) {
        return (Button)this.dialogPane.lookupButton(buttonType);
    }

    private void configureCancelButton() {
        Button cancelButton = this.getButton(ButtonType.CANCEL);
        if (cancelButton != null) {
            cancelButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    HybridModalDialog.this.result = null;
                    HybridModalDialog.this.dispose();
                }
            });
        }
    }
}

