/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.utils.NullUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.eclipse.jdt.annotation.NonNull;

public class HistogramViewItem<T> {
    private Map<@NonNull T, Map<@NonNull String, Integer>> data = new HashMap<T, Map<String, Integer>>();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void addSeries(@NonNull T seriesID) {
        @NonNull Map oldValue = this.data.put(seriesID, new HashMap());
        assert (oldValue == null);
    }

    public ObservableList<String> getAllCategories() {
        return this.data.values().stream().flatMap(series -> series.keySet().stream()).distinct().collect(Collectors.toCollection(() -> FXCollections.observableArrayList()));
    }

    public ObservableList<String> getCategories(@NonNull T seriesID) {
        ObservableList categories = FXCollections.observableArrayList();
        categories.addAll(((Map)NullUtils.neverNull(this.data.get(seriesID))).keySet());
        return categories;
    }

    public Integer getCount(@NonNull T seriesID, String bin) {
        return (Integer)((Map)NullUtils.neverNull(this.data.get(seriesID))).get(bin);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void incBin(@NonNull T seriesID, String bin) {
        @NonNull @NonNull Map series = (Map)NullUtils.neverNull(this.data.get(seriesID));
        assert (bin != null);
        if (series.containsKey(bin)) {
            int count = (Integer)NullUtils.neverNull((Object)((Integer)series.get(bin))) + 1;
            series.remove(bin);
            series.put(bin, count);
        } else {
            series.put(bin, 1);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void addEmptyBin(@NonNull T seriesID, String bin) {
        @NonNull @NonNull Map series = (Map)NullUtils.neverNull(this.data.get(seriesID));
        assert (bin != null);
        series.put(bin, 0);
    }
}

