/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.utils.NullUtils;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.concurrent.Task;
import javafx.scene.chart.XYChart;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class HistogramController {
    private final @NonNull BooleanProperty taskRunning = new SimpleBooleanProperty(false);
    private final @NonNull ObjectProperty<@Nullable HistogramInformation> histogramInfo = new SimpleObjectProperty();
    private final @NonNull ExecutorService executor = NamedExecutors.cachedFiniteThreadPool((int)1, (long)60L, (TimeUnit)TimeUnit.SECONDS, (NamedThreadFactory)new NamedThreadFactory("HistogramController Executor"));
    private final @NonNull SimpleDoubleProperty progress = new SimpleDoubleProperty();

    public void dispose() {
        this.executor.shutdown();
    }

    public @NonNull ReadOnlyObjectProperty<HistogramInformation> getHistogramInfo() {
        return this.histogramInfo;
    }

    public @NonNull ReadOnlyDoubleProperty getProgress() {
        return this.progress;
    }

    public @NonNull ReadOnlyBooleanProperty getTaskRunning() {
        return this.taskRunning;
    }

    public void invokeDataReloaderTask(@Nullable Task<@NonNull HistogramInformation> informationLoaderTask) {
        Platform.runLater(() -> {
            if (informationLoaderTask != null) {
                this.histogramInfo.unbind();
                this.histogramInfo.bind((ObservableValue)informationLoaderTask.valueProperty());
                this.progress.unbind();
                this.progress.bind((ObservableValue)informationLoaderTask.progressProperty());
                this.taskRunning.unbind();
                this.taskRunning.bind((ObservableValue)informationLoaderTask.runningProperty());
                this.executor.submit((Runnable)informationLoaderTask);
            } else {
                this.histogramInfo.unbind();
                this.histogramInfo.setValue((Object)new HistogramInformation());
                this.progress.unbind();
                this.progress.set(0.0);
                this.taskRunning.unbind();
                this.taskRunning.set(false);
            }
        });
    }

    public static class HistogramInformation {
        private final @NonNull ObservableList<// Could not load outer class - annotation placement on inner may be incorrect
        XYChart.Series<String, Number>> seriesToAdd = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
        private final @NonNull ObservableList<String> taskCategories = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
        private final @NonNull ObservableMap<String, int[]> categoryColourMap = (ObservableMap)NullUtils.neverNull((Object)FXCollections.observableHashMap());
        private final @NonNull ObservableMap<String, String> categoryTooltipMap = (ObservableMap)NullUtils.neverNull((Object)FXCollections.observableHashMap());
        private final @NonNull ReadOnlyStringWrapper frequencyLabel = new ReadOnlyStringWrapper();
        private final @NonNull ReadOnlyStringWrapper categoriesLabel = new ReadOnlyStringWrapper();
        private final @NonNull ReadOnlyObjectWrapper<@Nullable Comparator<String>> comparator = new ReadOnlyObjectWrapper();

        public ObservableList<String> getCategories() {
            return this.taskCategories;
        }

        public ObservableList<XYChart.Series<String, Number>> getSeriesToAdd() {
            return this.seriesToAdd;
        }

        public ObservableMap<String, int[]> getCategoryColours() {
            return this.categoryColourMap;
        }

        public ObservableMap<String, String> getCategoryTooltips() {
            return this.categoryTooltipMap;
        }

        public void setCategories(ObservableList<String> newCategories) {
            this.taskCategories.clear();
            this.taskCategories.addAll(newCategories);
        }

        public void setSeriesToAdd(ObservableList<XYChart.Series<String, Number>> newSeriesToAdd) {
            this.seriesToAdd.clear();
            this.seriesToAdd.addAll(newSeriesToAdd);
        }

        public void setCategoryColour(String category, int[] selectedColour) {
            this.categoryColourMap.put((Object)category, (Object)selectedColour);
        }

        public void setCategoryTooltip(String category, String tooltip) {
            this.categoryTooltipMap.put((Object)category, (Object)tooltip);
        }

        public void clear() {
            this.seriesToAdd.clear();
            this.taskCategories.clear();
            this.categoryTooltipMap.clear();
            this.categoryColourMap.clear();
        }

        public @NonNull String getCSVString() {
            StringBuilder csv = new StringBuilder();
            for (XYChart.Series series : this.seriesToAdd) {
                csv.append(HistogramInformation.addQuotationMarks(series.getChart().getXAxis().getLabel()));
                csv.append(",");
                csv.append(HistogramInformation.addQuotationMarks(series.getChart().getYAxis().getLabel()));
                csv.append("\n");
                ObservableList list = series.getData();
                for (XYChart.Data item : list) {
                    csv.append(HistogramInformation.addQuotationMarks((String)item.getXValue()));
                    csv.append(",");
                    csv.append(item.getYValue());
                    csv.append("\n");
                }
                csv.append("\n");
            }
            return NullUtils.buildString((StringBuilder)csv);
        }

        private static String addQuotationMarks(String in) {
            StringBuilder out = new StringBuilder("\"");
            out.append(in);
            out.append("\"");
            return out.toString();
        }

        public @NonNull ReadOnlyStringProperty getFrequencyLabel() {
            return (ReadOnlyStringProperty)NullUtils.neverNull((Object)this.frequencyLabel.getReadOnlyProperty());
        }

        public @NonNull ReadOnlyStringProperty getCategoriesLabel() {
            return (ReadOnlyStringProperty)NullUtils.neverNull((Object)this.categoriesLabel.getReadOnlyProperty());
        }

        public @NonNull ReadOnlyObjectProperty<@Nullable Comparator<String>> getComparator() {
            return (ReadOnlyObjectProperty)NullUtils.neverNull((Object)this.comparator.getReadOnlyProperty());
        }

        public void setCategoriesLabel(@NonNull String categoriesLabel) {
            this.categoriesLabel.set(categoriesLabel);
        }

        public void setFrequencyLabel(@NonNull String frequencyLabel) {
            this.frequencyLabel.set(frequencyLabel);
        }

        public void setComparator(@Nullable Comparator<String> comparator) {
            this.comparator.set(comparator);
        }
    }
}

