/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.ui.utils.NumberMultipleStringComparator;
import com.arm.mgd.utils.NullUtils;
import java.util.Comparator;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.StackedBarChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.StackPane;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class HistogramChart
extends StackedBarChart<String, Number> {
    private final @NonNull HashMap<String, Number> categoryValueMap = new HashMap();
    private final @NonNull HashMap<String, int[]> categoryColourMap = new HashMap();
    private final @NonNull HashMap<String, String> categoryTooltipMap = new HashMap();
    private final @NonNull CategoryAxis xAxis;
    private final @NonNull NumberAxis yAxis;
    private @Nullable Comparator<String> comparator = new NumberMultipleStringComparator();
    private final long maxBarWidth = 100L;
    private final long minCategoryGap = 10L;

    private static CategoryAxis initXAxis() {
        CategoryAxis xAxis = new CategoryAxis();
        xAxis.setAnimated(false);
        return xAxis;
    }

    private static NumberAxis initYAxis() {
        NumberAxis yAxis = new NumberAxis();
        yAxis.setAnimated(false);
        return yAxis;
    }

    public HistogramChart() {
        super((Axis)HistogramChart.initXAxis(), (Axis)HistogramChart.initYAxis());
        this.dataProperty().set((Object)FXCollections.observableArrayList());
        this.setAnimated(false);
        this.setLegendVisible(false);
        this.xAxis = (CategoryAxis)NullUtils.neverNull((Object)((CategoryAxis)super.getXAxis()));
        this.yAxis = (NumberAxis)NullUtils.neverNull((Object)((NumberAxis)this.getYAxis()));
        this.setMaxBarWidth();
        this.widthProperty().addListener((obs, b, b1) -> Platform.runLater(() -> this.setMaxBarWidth()));
    }

    private void sortChart(final @NonNull Comparator<String> labelComparator) {
        for (XYChart.Series series : this.getData()) {
            series.getData().sort((Comparator)new Comparator<XYChart.Data<String, Number>>(){

                @Override
                public int compare(XYChart.Data<String, Number> o1, XYChart.Data<String, Number> o2) {
                    return labelComparator.compare((String)o1.getXValue(), (String)o2.getXValue());
                }
            });
        }
    }

    protected void layoutChildren() {
        this.sortChart(this.comparator != null ? this.comparator : new MapValueComparator());
        super.layoutChildren();
    }

    public void layoutPlotChildren() {
        for (XYChart.Series series : this.getData()) {
            for (XYChart.Data bar : series.getData()) {
                String category = (String)bar.getXValue();
                if (!this.categoryColourMap.containsKey(category)) continue;
                int @NonNull [] colour = NullUtils.neverNull((int[])this.categoryColourMap.get(category));
                String hexColour = String.format("#%02x%02x%02x", colour[0], colour[1], colour[2]);
                String styleStr = "-fx-bar-fill: " + hexColour + ";";
                StackPane barNode = (StackPane)bar.getNode();
                barNode.setStyle(styleStr);
            }
        }
        this.setMaxBarWidth();
        super.layoutPlotChildren();
    }

    public void setXAxisLabel(String xAxisLabel) {
        this.xAxis.setLabel(xAxisLabel);
    }

    public void setYAxisLabel(String yAxisLabel) {
        this.yAxis.setLabel(yAxisLabel);
    }

    public CategoryAxis getXAxis() {
        return this.xAxis;
    }

    protected void seriesAdded(XYChart.Series<String, Number> series, int seriesIndex) {
        super.seriesAdded(series, seriesIndex);
        for (XYChart.Data item : series.getData()) {
            String category = (String)item.getXValue();
            if (this.categoryValueMap.keySet().contains(category)) {
                double value = ((Number)NullUtils.neverNull((Object)this.categoryValueMap.get(category))).doubleValue();
                this.categoryValueMap.put(category, ((Number)item.getYValue()).doubleValue() + value);
                continue;
            }
            this.categoryValueMap.put(category, (Number)item.getYValue());
        }
        for (XYChart.Data item : series.getData()) {
            Tooltip tooltip = new Tooltip();
            String tooltipString = this.categoryTooltipMap.get(item.getXValue());
            if (tooltipString == null) {
                tooltipString = ((Number)item.getYValue()).toString();
            }
            tooltip.setText(tooltipString);
            Tooltip.install((Node)item.getNode(), (Tooltip)tooltip);
        }
    }

    protected void seriesRemoved(XYChart.Series<String, Number> series) {
        super.seriesRemoved(series);
        for (XYChart.Data item : series.getData()) {
            String category = (String)item.getXValue();
            this.categoryValueMap.remove(category);
        }
    }

    public void setComparator(@Nullable Comparator<String> newComparator) {
        this.comparator = newComparator;
    }

    public HashMap<String, int[]> getCategoryColourMap() {
        return this.categoryColourMap;
    }

    public HashMap<String, String> getCategoryTooltipMap() {
        return this.categoryTooltipMap;
    }

    private void setMaxBarWidth() {
        int dataSize = this.getData().size();
        if (dataSize == 0) {
            return;
        }
        double categorySpacing = this.xAxis.getCategorySpacing();
        double barWidth = (categorySpacing - this.getCategoryGap()) / (double)dataSize;
        if (barWidth <= 100.0 && barWidth > 0.0) {
            return;
        }
        double newCategoryGap = categorySpacing - (double)(100L * (long)dataSize);
        if (newCategoryGap > 10.0) {
            this.setCategoryGap(newCategoryGap);
        } else {
            this.setCategoryGap(10.0);
        }
    }

    private class MapValueComparator
    implements Comparator<String> {
        private MapValueComparator() {
        }

        @Override
        public int compare(String cat1, String cat2) {
            double val2;
            if (!HistogramChart.this.categoryValueMap.containsKey(cat1) || !HistogramChart.this.categoryValueMap.containsKey(cat2)) {
                return 0;
            }
            double val1 = ((Number)NullUtils.neverNull((Object)HistogramChart.this.categoryValueMap.get(cat1))).doubleValue();
            return val1 > (val2 = ((Number)NullUtils.neverNull((Object)HistogramChart.this.categoryValueMap.get(cat2))).doubleValue()) ? -1 : (val1 == val2 ? 0 : 1);
        }
    }
}

