/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.ui.controls.FXCanvasWithMouseWheelFix;
import com.arm.mgd.ui.controls.IFXPartVisibilityListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Scene;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public abstract class FXEditorPart
extends EditorPart
implements IFXPartVisibilityListener {
    private final @NonNull BooleanProperty visibleProperty = new SimpleBooleanProperty(false);
    private FXCanvas canvas;

    public void createPartControl(Composite parent) {
        this.canvas = new FXCanvasWithMouseWheelFix(parent, 0);
        this.canvas.setScene(this.createFxScene());
        String helpId = this.getHelpId();
        if (helpId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.canvas, helpId);
        }
    }

    public void dispose() {
        this.canvas.dispose();
        super.dispose();
    }

    public void setFocus() {
        this.canvas.setFocus();
        this.setFxFocus();
    }

    @Override
    public void setVisible(boolean visible) {
        this.canvas.setVisible(visible);
        this.visibleProperty.set(visible);
    }

    protected @NonNull ReadOnlyBooleanProperty visibleProperty() {
        return this.visibleProperty;
    }

    protected abstract Scene createFxScene();

    protected abstract void setFxFocus();

    protected abstract @Nullable String getHelpId();
}

