/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.Activator;
import com.arm.mgd.ui.handlers.ConnectTargetHandler;
import com.arm.mgd.ui.targetconn.LiveConnectionSettings;
import com.arm.mgd.ui.targetconn.LiveTargetConnection;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ConnectIPControl
extends VBox {
    private static final int PORT_MINIMUM_VALUE = 1;
    private static final int PORT_MAXIMUM_VALUE = 65535;
    @FXML
    private TextField ipAddressField;
    @FXML
    private TextField portField;
    private @Nullable String resolvedIP = null;
    private int resolvedPort = 0;
    @FXML
    private Button connectButton;
    @FXML
    private Text errorText;
    @FXML
    private HBox connectingSpinner;
    private final @NonNull ReadOnlyBooleanProperty canConnectProperty;
    private final @NonNull BooleanProperty connectionInProgressProperty = new SimpleBooleanProperty(false);
    private final @NonNull BooleanProperty onConnectionOccurredProperty = new SimpleBooleanProperty(false);
    private final @NonNull EventHandler<KeyEvent> enterPressedHandler = event -> {
        if (event.getCode().equals((Object)KeyCode.ENTER)) {
            this.doConnect();
        }
    };

    public ConnectIPControl() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/resources/connectIPControl.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
        }
        ContextMenuHelper.createAndSetContextMenuForTextInputField((TextInputControl)NullUtils.neverNull((Object)this.ipAddressField), false);
        ContextMenuHelper.createAndSetContextMenuForTextInputField((TextInputControl)NullUtils.neverNull((Object)this.portField), false);
        SimpleBooleanProperty canConnect = new SimpleBooleanProperty(false);
        canConnect.bind((ObservableValue)this.errorText.textProperty().isEmpty());
        this.canConnectProperty = canConnect;
        this.connectButton.setOnAction(event -> this.doConnect());
        this.connectButton.disableProperty().bind((ObservableValue)this.canConnectProperty.not().or((ObservableBooleanValue)this.connectionInProgressProperty));
        this.ipAddressField.disableProperty().bind((ObservableValue)this.connectionInProgressProperty);
        this.portField.disableProperty().bind((ObservableValue)this.connectionInProgressProperty);
        this.ipAddressField.setOnKeyPressed(this.enterPressedHandler);
        this.portField.setOnKeyPressed(this.enterPressedHandler);
        this.ipAddressField.setText(LiveConnectionSettings.getIPAddress());
        this.portField.setText(Integer.toString(LiveConnectionSettings.getPort()));
        this.ipAddressField.textProperty().addListener(observable -> this.validateInputsOnTextChange());
        this.portField.textProperty().addListener(observable -> this.validateInputsOnTextChange());
        this.connectingSpinner.visibleProperty().bind((ObservableValue)this.connectionInProgressProperty);
        this.validateInputsOnTextChange();
    }

    private void doConnect() {
        if (!this.canConnectProperty.get()) {
            return;
        }
        @NonNull String ipToConnectTo = (String)NullUtils.neverNull((Object)this.resolvedIP);
        int portToConnectTo = this.resolvedPort;
        LiveConnectionSettings.setCurrentPortAndAddress(ipToConnectTo, portToConnectTo);
        Activator.getDefault().saveConnectionSettings();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        this.connectionInProgressProperty.set(true);
        new Thread(() -> {
            @Nullable LiveTargetConnection newConnection = ConnectTargetHandler.doConnectTargetSynchronous(ipToConnectTo, portToConnectTo, null, null, null, window);
            Platform.runLater(() -> {
                this.connectionInProgressProperty.set(false);
                if (newConnection != null) {
                    this.onConnectionOccurredProperty.set(!this.onConnectionOccurredProperty.get());
                }
            });
        }).start();
    }

    private void validateInputsOnTextChange() {
        @Nullable String errorMessage = "Can't connect";
        try {
            String inputIP = this.ipAddressField.getText().trim();
            if (inputIP.isEmpty()) {
                errorMessage = "IP Address must not be empty";
                return;
            }
            int inputPort = -1;
            try {
                inputPort = Integer.parseInt(this.portField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (inputPort < 1 || inputPort > 65535) {
                errorMessage = "Port must be a number between 1 and 65535 inclusive.";
                return;
            }
            errorMessage = null;
            this.resolvedIP = inputIP;
            this.resolvedPort = inputPort;
        }
        finally {
            this.errorText.setText(errorMessage);
        }
    }

    public @NonNull Observable onConnectionOccuredObservable() {
        return this.onConnectionOccurredProperty;
    }
}

