/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.INavigationUriVisitor;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.FXImages;
import com.arm.mgd.ui.controllers.BreadcrumbBarController;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BreadcrumbBar
extends HBox {
    @FXML
    private Button backButton;
    @FXML
    private Button homeButton;
    @FXML
    private HBox breadcrumbPane;
    private final @NonNull ObjectProperty<NavigationUri> currentNavigationURI = new SimpleObjectProperty();
    private final @NonNull BreadcrumbBarController controller = new BreadcrumbBarController();
    private static final @NonNull PseudoClass MIDDLE_BREADCRUMB_PSUEDO_CLASS = (PseudoClass)NullUtils.neverNull((Object)PseudoClass.getPseudoClass((String)"middle-breadcrumb"));
    private static final @NonNull PseudoClass LAST_BREADCRUMB_PSUEDO_CLASS = (PseudoClass)NullUtils.neverNull((Object)PseudoClass.getPseudoClass((String)"last-breadcrumb"));
    private final @NonNull BreadCrumbButtonCache breadcrumbButtonCache = new BreadCrumbButtonCache();

    public BreadcrumbBar() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/resources/breadcrumbBar.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException e2) {
            CoreLogging.severe((Throwable)e2);
        }
        this.backButton.setOnAction(e -> this.controller.backCommand());
        this.backButton.disableProperty().bind((ObservableValue)this.controller.getUriStackEmptyProperty());
        this.homeButton.setOnAction(e -> this.controller.homeCommand());
        this.homeButton.disableProperty().bind((ObservableValue)this.controller.homeAvailableProperty().not());
        this.currentNavigationURIProperty().bind(this.controller.currentNavigationURIProperty());
        this.currentNavigationURI.addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.createBreadcrumbs((NavigationUri)newValue)));
    }

    public ObjectProperty<NavigationUri> currentNavigationURIProperty() {
        return this.currentNavigationURI;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createBreadcrumbs(@Nullable NavigationUri newValue) {
        assert (Platform.isFxApplicationThread());
        this.breadcrumbButtonCache.reset();
        final ArrayList<@NonNull E> breadcrumbChildren = new ArrayList();
        NavigationUri.accept((NavigationUri)newValue, (INavigationUriVisitor)new INavigationUriVisitor<Void>(){

            public Void dontCare() {
                return null;
            }

            public Void visit(@NonNull AbstractTarget target, @NonNull TraceDataModel model) {
                breadcrumbChildren.add(BreadcrumbBar.this.breadcrumbButtonCache.getButton((INavigationElement<?>)model));
                return null;
            }

            public Void visit(@NonNull AbstractTarget target, @NonNull TraceDataModel model, @NonNull Frame frame) {
                this.visit(target, model);
                breadcrumbChildren.add(BreadcrumbBar.this.breadcrumbButtonCache.getButton((INavigationElement<?>)frame));
                return null;
            }

            public Void visit(@NonNull AbstractTarget target, @NonNull TraceDataModel model, @NonNull Frame frame, @NonNull FrameRenderPass frameRenderPass) {
                this.visit(target, model, frame);
                breadcrumbChildren.add(BreadcrumbBar.this.breadcrumbButtonCache.getButton((INavigationElement<?>)frameRenderPass));
                return null;
            }

            public Void visit(@NonNull AbstractTarget target, @NonNull TraceDataModel model, @NonNull Frame frame, @NonNull FrameRenderPass frameRenderPass, @NonNull FunctionCall functionCall) {
                this.visit(target, model, frame, frameRenderPass);
                breadcrumbChildren.add(BreadcrumbBar.this.breadcrumbButtonCache.getButton((INavigationElement<?>)functionCall));
                return null;
            }
        });
        ArrayList<Object> paneNodes = new ArrayList<Object>(breadcrumbChildren.size() * 2);
        int i = 0;
        while (i < breadcrumbChildren.size()) {
            paneNodes.add(new ImageView(FXImages.BREADCRUMB_SEPARATOR));
            BreadcrumbButton button = (BreadcrumbButton)((Object)breadcrumbChildren.get(i));
            button.setIsLastButton(i == breadcrumbChildren.size() - 1);
            paneNodes.add((Object)button);
            ++i;
        }
        this.breadcrumbPane.getChildren().setAll(paneNodes);
    }

    private class BreadCrumbButtonCache {
        private final ArrayList<@NonNull BreadcrumbButton> buttons = new ArrayList();
        private int offset = 0;

        private BreadCrumbButtonCache() {
        }

        private void reset() {
            this.offset = 0;
            for (BreadcrumbButton button : this.buttons) {
                button.reset();
            }
        }

        private @NonNull BreadcrumbButton getButton(@NonNull INavigationElement<?> targetElement) {
            if (this.buttons.size() <= this.offset) {
                this.buttons.add(new BreadcrumbButton());
            }
            BreadcrumbButton button = this.buttons.get(this.offset);
            ++this.offset;
            button.setTarget(targetElement);
            return button;
        }
    }

    private class BreadcrumbButton
    extends Button {
        private final @NonNull Tooltip tooltip = new Tooltip();

        private BreadcrumbButton() {
            this.getStyleClass().add((Object)"breadcrumb");
            this.setTooltip(this.tooltip);
        }

        private void reset() {
            this.setOnAction(null);
            this.setText(null);
            this.tooltip.setText(null);
        }

        private void setTarget(@NonNull INavigationElement<?> targetElement) {
            this.setText(targetElement.getLabelText());
            this.tooltip.setText(targetElement.getToolTipText());
            this.setOnAction(event -> BreadcrumbBar.this.controller.setNavigationUri(new NavigationUri(targetElement)));
        }

        private void setIsLastButton(boolean isLastButton) {
            this.pseudoClassStateChanged(MIDDLE_BREADCRUMB_PSUEDO_CLASS, !isLastButton);
            this.pseudoClassStateChanged(LAST_BREADCRUMB_PSUEDO_CLASS, isLastButton);
        }
    }
}

