/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.ui.FXImages;
import com.arm.mgd.ui.controllers.AndroidDeviceControlItem;
import com.arm.mgd.ui.controllers.AndroidDeviceControlItemConnection;
import com.arm.mgd.ui.controls.AbstractAndroidDeviceControl;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import java.util.List;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.stage.WindowEvent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AndroidDeviceControl
extends AbstractAndroidDeviceControl {
    @FXML
    private TableColumn<@NonNull AndroidDeviceControlItem, ADBDeviceIdentifier> deviceIdColumn;
    @FXML
    private TableColumn<@NonNull AndroidDeviceControlItem, ADBDevice> deviceNameColumn;
    @FXML
    private TableColumn<@NonNull AndroidDeviceControlItem, AndroidDeviceControlItemConnection.Info> isConnectedColumn;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public AndroidDeviceControl() {
        this.deviceIdColumn.setCellValueFactory(item -> new SimpleObjectProperty((Object)((AndroidDeviceControlItem)item.getValue()).getDeviceIdentifier()));
        this.deviceIdColumn.setCellFactory(column -> new AbstractAndroidDeviceControl.DeviceIDColumnCell());
        this.deviceNameColumn.setCellValueFactory(item -> new SimpleObjectProperty((Object)((AndroidDeviceControlItem)item.getValue()).getDevice()));
        this.deviceNameColumn.setCellFactory(column -> new AbstractAndroidDeviceControl.DeviceNameColumnCell());
        this.isConnectedColumn.setCellValueFactory(item -> ((AndroidDeviceControlItem)item.getValue()).getConnection().infoProperty());
        this.isConnectedColumn.setCellFactory(column -> new DeviceConnectionInfoColumnCell());
        @NonNull SimpleListProperty selectedItems = new SimpleListProperty(this.devicesTable.getSelectionModel().getSelectedItems());
        MenuItem refresh = new MenuItem("Refresh all devices");
        MenuItem reboot = new MenuItem("Reboot the selected device(s)");
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{refresh, new SeparatorMenuItem(), reboot});
        refresh.setOnAction(event -> this.controller.fullRefreshDevices());
        reboot.setOnAction(arg_0 -> this.lambda$7((ListProperty)selectedItems, arg_0));
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull((Object)this.devicesTable), contextMenu);
        contextMenu.setOnShowing(arg_0 -> this.lambda$8(refresh, reboot, (ListProperty)selectedItems, arg_0));
    }

    public @NonNull ReadOnlyObjectProperty<AndroidDeviceControlItem> getSelectedDeviceItemProperty() {
        return this.controller.getSelectedDeviceItemProperty();
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable AndroidBridge> getAndroidBridgeProperty() {
        return this.controller.getAndroidBridgeProperty();
    }

    @Override
    protected @NonNull String getResourcePath() {
        return "/resources/androidDeviceControl.fxml";
    }

    private /* synthetic */ void lambda$7(ListProperty listProperty, ActionEvent event) {
        this.controller.reboot((List<AndroidDeviceControlItem>)listProperty);
    }

    private /* synthetic */ void lambda$8(MenuItem menuItem, MenuItem menuItem2, ListProperty listProperty, WindowEvent event) {
        menuItem.setDisable(false);
        menuItem2.setDisable(!this.controller.canReboot((List<AndroidDeviceControlItem>)listProperty));
    }

    private class DeviceConnectionInfoColumnCell
    extends TableCell<AndroidDeviceControlItem, AndroidDeviceControlItemConnection.Info> {
        private final @NonNull Label notConnectedLabel = new Label("Disconnected", (Node)new ImageView(FXImages.DISCONNECT));
        private final @NonNull Label connectedLabel = new Label("Connected", (Node)new ImageView(FXImages.CONNECT));
        private final @NonNull StackPane iconStack = new StackPane(new Node[]{this.notConnectedLabel, this.connectedLabel});
        private final @NonNull Tooltip tooltip = new Tooltip();

        private DeviceConnectionInfoColumnCell() {
            this.setGraphic((Node)this.iconStack);
            this.setAlignment(Pos.CENTER_LEFT);
            this.notConnectedLabel.setPadding(new Insets(3.0));
            this.notConnectedLabel.setTooltip(new Tooltip("This device does not have an active connection"));
            this.connectedLabel.setPadding(new Insets(3.0));
            this.connectedLabel.setTooltip(new Tooltip("This device has an active connection"));
        }

        private void setAllIconsNotVisible() {
            this.iconStack.getChildren().forEach(child -> child.setVisible(false));
        }

        protected void updateItem(AndroidDeviceControlItemConnection.Info item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setTooltip(null);
                this.iconStack.setVisible(false);
            } else {
                this.setTooltip(this.tooltip);
                this.tooltip.setText(item.getInfo());
                this.iconStack.setVisible(true);
                this.setAllIconsNotVisible();
                AndroidDeviceControlItemConnection.ConnectionStatus status = item.getStatus();
                switch (status) {
                    case OPERATION_IN_PROGRESS: {
                        break;
                    }
                    case CONNECTED: {
                        this.connectedLabel.setVisible(true);
                        this.setTooltip(null);
                        break;
                    }
                    case DISCONNECTED_AND_CAN_BE_CONNECTED_TO: {
                        this.notConnectedLabel.setVisible(true);
                        this.setTooltip(null);
                        break;
                    }
                    case DISCONNECTED_AND_CANT_CONNECT: {
                        this.notConnectedLabel.setVisible(true);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)status);
                    }
                }
            }
        }
    }
}

