/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.FXImages;
import com.arm.mgd.ui.controllers.AndroidDeviceControlController;
import com.arm.mgd.ui.controllers.AndroidDeviceControlItem;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.Set;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractAndroidDeviceControl
extends StackPane {
    protected AndroidDeviceControlController controller;
    @FXML
    protected TableView<AndroidDeviceControlItem> devicesTable;
    @FXML
    protected Label invalidADBReason;
    @FXML
    protected VBox configureADBBox;
    @FXML
    protected Button configureADBButton;
    @FXML
    protected VBox blockingUpdateProgressBox;
    private static final @NonNull Set<@NonNull KeyCode> DIRECTION_KEYS = NullUtils.setOf((Object[])new KeyCode[]{KeyCode.LEFT, KeyCode.RIGHT, KeyCode.UP, KeyCode.DOWN});

    public AbstractAndroidDeviceControl() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(this.getResourcePath()));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
        }
        this.controller = new AndroidDeviceControlController((SelectionModel<AndroidDeviceControlItem>)((SelectionModel)NullUtils.neverNull((Object)this.devicesTable.getSelectionModel())));
        this.devicesTable.itemsProperty().bind(this.controller.adbDevicesProperty());
        this.devicesTable.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (!this.devicesTable.isFocused()) {
                return;
            }
            if (!DIRECTION_KEYS.contains(event.getCode())) {
                return;
            }
            if (!this.devicesTable.getSelectionModel().isEmpty()) {
                return;
            }
            if (this.devicesTable.getItems().isEmpty()) {
                event.consume();
                return;
            }
            this.devicesTable.getSelectionModel().selectFirst();
        });
        this.devicesTable.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.devicesTable.focusedProperty().addListener((observable, oldValue, newValue) -> {
            TableView.TableViewSelectionModel selectionModel = this.devicesTable.getSelectionModel();
            if (newValue.booleanValue() && selectionModel.isEmpty()) {
                selectionModel.selectFirst();
            }
        });
        this.devicesTable.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (this.devicesTable.getSelectionModel().getSelectedItem() != null && keyEvent.getCode() == KeyCode.ENTER) {
                @Nullable Scene scene = this.getScene();
                if (scene == null) {
                    return;
                }
                @Nullable Node packagesTable = scene.lookup("#PackagesTable");
                if (packagesTable != null) {
                    packagesTable.requestFocus();
                }
            }
        });
        Label placeHolderLabel = new Label("No devices found");
        this.devicesTable.setPlaceholder((Node)placeHolderLabel);
        placeHolderLabel.visibleProperty().bind((ObservableValue)this.invalidADBReason.textProperty().isEmpty());
        this.devicesTable.focusTraversableProperty().bind((ObservableValue)this.controller.hasADBLoadedProperty().and((ObservableBooleanValue)Bindings.isNotEmpty((ObservableList)this.devicesTable.getItems())));
        this.configureADBBox.visibleProperty().bind((ObservableValue)this.controller.hasADBLoadedProperty().not());
        this.invalidADBReason.textProperty().bind((ObservableValue)this.controller.invalidADBReasonProperty());
        this.configureADBButton.setOnAction(event -> {
            this.controller.launchADBConfigurationDialog();
            this.devicesTable.requestFocus();
        });
        this.blockingUpdateProgressBox.visibleProperty().bind((ObservableValue)this.controller.blockingUpdateInProgressProperty());
    }

    protected abstract @NonNull String getResourcePath();

    public void dispose() {
        this.controller.dispose();
    }

    protected static class DeviceIDColumnCell
    extends TableCell<AndroidDeviceControlItem, ADBDeviceIdentifier> {
        private final @NonNull Tooltip tooltip = new Tooltip();

        protected DeviceIDColumnCell() {
            this.setAlignment(Pos.CENTER_LEFT);
            this.tooltip.textProperty().bind((ObservableValue)this.textProperty());
        }

        protected final void updateItem(ADBDeviceIdentifier item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setText(null);
                this.setTooltip(null);
            } else {
                String text = item.getStatus() != ADBDeviceIdentifier.Status.DEVICE ? "(" + item.getStatus().getName() + ") " + item.getID() : item.getID();
                this.setText(text);
                this.setTooltip(this.tooltip);
            }
        }
    }

    protected static class DeviceNameColumnCell
    extends TableCell<AndroidDeviceControlItem, ADBDevice> {
        private final @NonNull ImageView rootedImage = new ImageView(FXImages.LOCK_OPEN);
        private final @NonNull Tooltip tooltip = new Tooltip();

        protected DeviceNameColumnCell() {
            this.setAlignment(Pos.CENTER_LEFT);
        }

        protected final void updateItem(ADBDevice item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
                this.setText(null);
                this.setTooltip(null);
            } else {
                this.setText(item.toString());
                ImageView graphic = item.isRooted() ? this.rootedImage : null;
                this.setGraphic((Node)graphic);
                String rootedString = item.isRooted() ? " (rooted)" : "";
                this.tooltip.setText(String.valueOf(item.getUnambiguousName()) + rootedString);
                this.setTooltip(this.tooltip);
            }
        }
    }
}

