/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.AndroidDeviceControlItem;
import com.arm.mgd.ui.controls.ADBPackageControl;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.layout.VBox;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ADBPackageVBox
extends VBox {
    private ADBPackageControl packageControl;
    @FXML
    private VBox packageControlBox;
    @FXML
    private Button launchActivityButton;
    @FXML
    private Button refreshPackagesButton;
    @FXML
    private CheckBox showOnlyDebuggableCheckbox;
    @FXML
    private RadioButton glesRadioButton;
    @FXML
    private RadioButton vulkanRadioButton;
    private BooleanProperty isDeviceOnline = new SimpleBooleanProperty(false);
    private BooleanProperty isDeviceConnected = new SimpleBooleanProperty(false);

    public ADBPackageVBox(@NonNull ReadOnlyObjectProperty<AndroidDeviceControlItem> selectedDeviceItem, @NonNull ReadOnlyObjectProperty<@Nullable AndroidBridge> bridgeProperty) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/resources/adbPackageControlVBox.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
        }
        selectedDeviceItem.addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                this.isDeviceOnline.unbind();
                this.isDeviceOnline.set(false);
                this.isDeviceConnected.unbind();
                this.isDeviceConnected.set(false);
                return;
            }
            this.isDeviceOnline.bind((ObservableValue)newValue.getDeviceOnlineProperty());
            this.isDeviceConnected.bind((ObservableValue)newValue.getDeviceConnectedProperty());
        });
        this.packageControl = new ADBPackageControl(selectedDeviceItem, bridgeProperty, this.showOnlyDebuggableCheckbox, this.getGLESEnabledProperty(), this.getVulkanEnabledProperty());
        this.packageControlBox.getChildren().add((Object)this.packageControl);
        this.refreshPackagesButton.setOnAction(event -> this.packageControl.getController().listPackages());
        this.refreshPackagesButton.disableProperty().bind((ObservableValue)selectedDeviceItem.isNull().or((ObservableBooleanValue)this.isDeviceOnline.not()).or((ObservableBooleanValue)this.packageControl.getController().blockingUpdateInProgressProperty()));
        this.showOnlyDebuggableCheckbox.disableProperty().bind((ObservableValue)this.refreshPackagesButton.disabledProperty());
        this.launchActivityButton.setOnAction(event -> this.packageControl.getController().launchActivityAndConnect());
        this.launchActivityButton.disableProperty().bind((ObservableValue)selectedDeviceItem.isNull().or((ObservableBooleanValue)this.isDeviceConnected).or((ObservableBooleanValue)this.packageControl.getController().isSelectedPackageItemDebuggableProperty().not()));
        this.glesRadioButton.disableProperty().bind((ObservableValue)this.launchActivityButton.disabledProperty());
        this.vulkanRadioButton.disableProperty().bind((ObservableValue)this.launchActivityButton.disabledProperty());
    }

    public @NonNull Observable onConnectionOccuredObservable() {
        return this.packageControl.onConnectionOccuredObservable();
    }

    public void dispose() {
        this.packageControl.dispose();
    }

    public @NonNull ReadOnlyBooleanProperty getGLESEnabledProperty() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.glesRadioButton.selectedProperty());
    }

    public @NonNull ReadOnlyBooleanProperty getVulkanEnabledProperty() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.vulkanRadioButton.selectedProperty());
    }
}

