/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.core.adb.ADBInstalledPackage;
import com.arm.mgd.utils.NullUtils;
import java.text.Collator;
import org.eclipse.jdt.annotation.NonNull;

public class ADBPackageItem
implements Comparable<ADBPackageItem> {
    private static final @NonNull Collator COLLATOR = (Collator)NullUtils.neverNull((Object)Collator.getInstance());
    private final @NonNull ADBInstalledPackage selectedPackage;
    private final @NonNull String selectedActivity;

    public ADBPackageItem(@NonNull ADBInstalledPackage selectedPackage, @NonNull String activity) {
        this.selectedPackage = selectedPackage;
        this.selectedActivity = activity;
    }

    public @NonNull ADBInstalledPackage getSelectedPackage() {
        return this.selectedPackage;
    }

    public @NonNull String getSelectedActivity() {
        return this.selectedActivity;
    }

    public boolean isDebuggable() {
        return this.selectedPackage.isDebuggable();
    }

    @Override
    public int compareTo(ADBPackageItem other) {
        if (this.getSelectedPackage().isDebuggable() != other.getSelectedPackage().isDebuggable()) {
            return Boolean.compare(other.getSelectedPackage().isDebuggable(), this.getSelectedPackage().isDebuggable());
        }
        if (!this.getSelectedPackage().getPackageName().equals(other.getSelectedPackage().getPackageName())) {
            return COLLATOR.compare(this.getSelectedPackage().getPackageName(), other.getSelectedPackage().getPackageName());
        }
        return COLLATOR.compare(this.getSelectedActivity(), other.getSelectedActivity());
    }
}

