/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controls;

import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.FXImages;
import com.arm.mgd.ui.controllers.ADBPackageControlController;
import com.arm.mgd.ui.controllers.AndroidDeviceControlItem;
import com.arm.mgd.ui.controls.ADBPackageItem;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ADBPackageControl
extends StackPane {
    @FXML
    private TableView<ADBPackageItem> packagesTable;
    @FXML
    private TableColumn<@NonNull ADBPackageItem, String> activityName;
    @FXML
    private TableColumn<@NonNull ADBPackageItem, String> packageName;
    @FXML
    private TableColumn<@NonNull ADBPackageItem, Boolean> isDebuggable;
    @FXML
    protected VBox blockingUpdateProgressBox;
    private @NonNull ADBPackageControlController controller;
    private final @NonNull FilteredList<@NonNull ADBPackageItem> filteredPackageItems;

    public ADBPackageControl(@NonNull ReadOnlyObjectProperty<AndroidDeviceControlItem> selectedDeviceItem, @NonNull ReadOnlyObjectProperty<@Nullable AndroidBridge> bridgeProperty, CheckBox showOnlyDebuggableCheckbox, @NonNull ReadOnlyBooleanProperty installGlesProperty, @NonNull ReadOnlyBooleanProperty installVulkanProperty) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/resources/adbPackageControlTable.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
        }
        this.controller = new ADBPackageControlController(selectedDeviceItem, (ReadOnlyObjectProperty<ADBPackageItem>)((ReadOnlyObjectProperty)NullUtils.neverNull((Object)this.packagesTable.getSelectionModel().selectedItemProperty())), bridgeProperty, installGlesProperty, installVulkanProperty);
        this.filteredPackageItems = new FilteredList(this.controller.listItemsProperty());
        this.packagesTable.setItems(this.filteredPackageItems);
        this.packagesTable.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (this.packagesTable.getSelectionModel().getSelectedItem() != null && keyEvent.getCode() == KeyCode.ENTER) {
                @Nullable Scene scene = this.getScene();
                if (scene == null) {
                    return;
                }
                @Nullable Node launchActivityButton = scene.lookup("#launchActivityButton");
                if (launchActivityButton != null && launchActivityButton instanceof Button && !launchActivityButton.isDisabled()) {
                    ((Button)launchActivityButton).fire();
                }
            }
        });
        showOnlyDebuggableCheckbox.selectedProperty().addListener((obs, o, n) -> this.filteredPackageItems.setPredicate(n != false ? ADBPackageItem::isDebuggable : null));
        this.packagesTable.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.packagesTable.setPlaceholder((Node)new Label("No device selected"));
        this.packagesTable.focusTraversableProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)this.packagesTable.getItems()));
        this.packageName.setCellValueFactory(item -> new SimpleStringProperty(((ADBPackageItem)item.getValue()).getSelectedPackage().getPackageName()));
        this.packageName.setCellFactory(column -> new PackagesTableCell());
        this.activityName.setCellValueFactory(item -> new SimpleStringProperty(((ADBPackageItem)item.getValue()).getSelectedActivity()));
        this.activityName.setCellFactory(item -> new PackagesTableCell());
        this.isDebuggable.setCellValueFactory(item -> new SimpleBooleanProperty(((ADBPackageItem)item.getValue()).getSelectedPackage().isDebuggable()));
        this.isDebuggable.setCellFactory(column -> new DebuggableColumnCell());
        this.blockingUpdateProgressBox.visibleProperty().bind((ObservableValue)this.controller.blockingUpdateInProgressProperty());
        this.controller.blockingUpdateInProgressProperty().addListener((observable, wasInProgress, nowInProgress) -> {
            if (wasInProgress.booleanValue() && !nowInProgress.booleanValue()) {
                this.packagesTable.getSelectionModel().selectFirst();
            }
        });
    }

    public void dispose() {
        this.controller.dispose();
    }

    public @NonNull Observable onConnectionOccuredObservable() {
        return this.controller.onConnectionOccuredObservable();
    }

    public @NonNull ADBPackageControlController getController() {
        return this.controller;
    }

    private class DebuggableColumnCell
    extends TableCell<ADBPackageItem, Boolean> {
        private final @NonNull Label notDebuggableLabel = new Label("", (Node)new ImageView(FXImages.CROSS));
        private final @NonNull Label debuggableLabel = new Label("", (Node)new ImageView(FXImages.TICK));
        private final @NonNull StackPane iconStack = new StackPane(new Node[]{this.notDebuggableLabel, this.debuggableLabel});

        private DebuggableColumnCell() {
            this.setGraphic((Node)this.iconStack);
            this.setAlignment(Pos.CENTER_LEFT);
            this.notDebuggableLabel.setPadding(new Insets(3.0));
            this.notDebuggableLabel.setTooltip(new Tooltip("This package is not debuggable"));
            this.debuggableLabel.setPadding(new Insets(3.0));
            this.debuggableLabel.setTooltip(new Tooltip("This package is debuggable"));
        }

        private void setAllIconsNotVisible() {
            this.iconStack.getChildren().forEach(child -> child.setVisible(false));
        }

        protected void updateItem(Boolean debuggable, boolean empty) {
            super.updateItem((Object)debuggable, empty);
            if (empty || debuggable == null) {
                this.setTooltip(null);
                this.iconStack.setVisible(false);
                return;
            }
            this.iconStack.setVisible(true);
            this.setAllIconsNotVisible();
            if (debuggable.booleanValue()) {
                this.debuggableLabel.setVisible(true);
                this.setTooltip(null);
            } else {
                this.notDebuggableLabel.setVisible(true);
                this.setTooltip(null);
            }
        }
    }

    private static class PackagesTableCell
    extends TableCell<ADBPackageItem, String> {
        private PackagesTableCell() {
            this.setAlignment(Pos.CENTER_LEFT);
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
            } else if (item == null) {
                this.setText("None");
            } else {
                this.setText(item.toString());
            }
        }
    }
}

