/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.statsview;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.INavigationUriVisitor;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.memoryreport.MemoryReportBin;
import com.arm.mgd.core.target.data.memoryreport.MemoryReportChannel;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.util.ByteStringUtils;
import com.arm.mgd.ui.controls.HistogramController;
import com.arm.mgd.ui.controls.SelectablePieChartController;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.chart.XYChart;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class StatisticsViewMemoryTabController {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull ReadOnlyStringWrapper currentFrameName = new ReadOnlyStringWrapper();
    private final @NonNull SimpleObjectProperty<@Nullable Frame> currentFrame = new SimpleObjectProperty();
    private final @NonNull ObservableList<String> histogramCategories = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull ObservableMap<String, int[]> histogramCategoryColourMap = (ObservableMap)NullUtils.neverNull((Object)FXCollections.observableHashMap());
    private final @NonNull ObservableMap<String, String> histogramCategoryTooltipMap = (ObservableMap)NullUtils.neverNull((Object)FXCollections.observableHashMap());
    private final @NonNull ObservableList<// Could not load outer class - annotation placement on inner may be incorrect
    XYChart.Series<String, Number>> histogramSeries = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull ReadOnlyStringWrapper histogramTitle = new ReadOnlyStringWrapper("");
    private final @NonNull ReadOnlyBooleanWrapper noMemoryReportDataToShow = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ObservableList<SelectablePieChartController.SelectableData<MemoryReportChannel>> pieChartData = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull ReadOnlyStringWrapper pieChartInfoLabel = new ReadOnlyStringWrapper("");
    private final @NonNull SimpleObjectProperty<MemoryReportChannel> selectedChannelProperty = new SimpleObjectProperty(null);
    private final @NonNull ReadOnlyBooleanWrapper showHistogram = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ReadOnlyStringWrapper csv = new ReadOnlyStringWrapper("");

    private static  @NonNull HistogramController.HistogramInformation createHistogramInfo(@NonNull MemoryReportChannel channel) {
        HistogramController.HistogramInformation histogramInfo = new HistogramController.HistogramInformation();
        ObservableList xAxisCategories = FXCollections.observableArrayList();
        ObservableList seriesToAdd = FXCollections.observableArrayList();
        XYChart.Series series = new XYChart.Series();
        for (MemoryReportBin bin : channel.getBins()) {
            assert (bin.getBin() > 0L);
            String binString = ByteStringUtils.byteRangeStringCreator((long)(1 << (int)(bin.getBin() - 1L)), (long)(1 << (int)bin.getBin()));
            String tooltip = ByteStringUtils.byteStringCreator((long)bin.getOccupiedMemory());
            histogramInfo.setCategoryTooltip(binString, tooltip);
            xAxisCategories.add((Object)binString);
            series.getData().add((Object)new XYChart.Data((Object)binString, (Object)bin.getMemoryAllocations()));
        }
        seriesToAdd.add((Object)series);
        histogramInfo.setCategories((ObservableList<String>)xAxisCategories);
        histogramInfo.setSeriesToAdd((ObservableList<XYChart.Series<String, Number>>)seriesToAdd);
        return histogramInfo;
    }

    private static @NonNull List<SelectablePieChartController.SelectableData<MemoryReportChannel>> getNewMemoryReportPieChartData(@NonNull TraceStateSnapshot snapshot) {
        ArrayList<SelectablePieChartController.SelectableData<MemoryReportChannel>> dataList = new ArrayList<SelectablePieChartController.SelectableData<MemoryReportChannel>>();
        for (MemoryReportChannel channel : snapshot.getMemoryReportModel().getMemoryReport()) {
            dataList.add(new SelectablePieChartController.SelectableData<MemoryReportChannel>(channel.getChannelName(), channel.getTotalAllocatedMemory(), channel, String.valueOf(ByteStringUtils.byteStringCreator((long)channel.getTotalAllocatedMemory())) + "\nDouble click to inspect."));
        }
        return dataList;
    }

    public StatisticsViewMemoryTabController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.noMemoryReportDataToShow.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.pieChartData.isEmpty(), (Observable[])new Observable[]{this.pieChartData}));
        this.histogramTitle.bind((ObservableValue)Bindings.createStringBinding(() -> {
            String frameName = this.currentFrameName.get();
            MemoryReportChannel selectedChannel = (MemoryReportChannel)this.selectedChannelProperty.get();
            if (frameName == null || selectedChannel == null) {
                return "";
            }
            return String.format("%s : %s", frameName, selectedChannel.getChannelName());
        }, (Observable[])new Observable[]{this.currentFrameName, this.selectedChannelProperty}));
        this.pieChartInfoLabel.bind((ObservableValue)Bindings.createStringBinding(() -> {
            MemoryReportChannel channel = (MemoryReportChannel)this.selectedChannelProperty.get();
            if (channel == null || this.noMemoryReportDataToShow.get()) {
                return "";
            }
            double totalMemoryDouble = 0.0;
            for (SelectablePieChartController.SelectableData data : this.pieChartData) {
                totalMemoryDouble += data.getPieChartData().getPieValue();
            }
            BigDecimal totalMemory = new BigDecimal(totalMemoryDouble);
            totalMemory = totalMemory.round(new MathContext(2));
            BigDecimal sliceMemory = new BigDecimal(channel.getTotalAllocatedMemory());
            sliceMemory = sliceMemory.round(new MathContext(2));
            double percentage = 100.0 * sliceMemory.doubleValue() / totalMemory.doubleValue();
            return String.format("%s: %s/%s (%.0f%%)", channel.getChannelName(), ByteStringUtils.byteStringCreator((long)sliceMemory.longValue()), ByteStringUtils.byteStringCreator((long)totalMemory.longValue()), percentage);
        }, (Observable[])new Observable[]{this.selectedChannelProperty, this.noMemoryReportDataToShow, this.pieChartData}));
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public void dispose() {
        this.navigationChangedListener.dispose();
        Platform.runLater(() -> this.currentFrame.set(null));
    }

    public @NonNull ReadOnlyStringProperty currentFrameNameProperty() {
        return (ReadOnlyStringProperty)NullUtils.neverNull((Object)this.currentFrameName.getReadOnlyProperty());
    }

    public @NonNull ObservableList<String> getHistogramCategories() {
        return this.histogramCategories;
    }

    public @NonNull ObservableMap<String, int[]> getHistogramCategoryColours() {
        return this.histogramCategoryColourMap;
    }

    public @NonNull ObservableMap<String, String> getHistogramCategoryTooltips() {
        return this.histogramCategoryTooltipMap;
    }

    public @NonNull ReadOnlyStringProperty getCSVStringProperty() {
        return (ReadOnlyStringProperty)NullUtils.neverNull((Object)this.csv.getReadOnlyProperty());
    }

    public @NonNull ObservableList<// Could not load outer class - annotation placement on inner may be incorrect
    XYChart.Series<String, Number>> getHistogramSeries() {
        return this.histogramSeries;
    }

    public ObservableList<SelectablePieChartController.SelectableData<MemoryReportChannel>> getMemoryReportPieData() {
        return this.pieChartData;
    }

    public ReadOnlyStringProperty histogramTitleProperty() {
        return this.histogramTitle.getReadOnlyProperty();
    }

    public ReadOnlyBooleanProperty noMemoryReportDataToShowProperty() {
        return this.noMemoryReportDataToShow;
    }

    private void onNavigationChanged(final @NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        Platform.runLater(() -> navigationUriChangeEvent.newUriAccept((INavigationUriVisitor)new INavigationUriVisitor<Void>(){

            public Void dontCare() {
                StatisticsViewMemoryTabController.this.currentFrameName.set(null);
                StatisticsViewMemoryTabController.this.currentFrame.set(null);
                StatisticsViewMemoryTabController.this.updateAll(null, null);
                return null;
            }

            public Void visit(@NonNull AbstractTarget target, @NonNull TraceDataModel model, @NonNull Frame frame) {
                StatisticsViewMemoryTabController.this.currentFrameName.set(frame.getLongLabelText());
                if (frame != StatisticsViewMemoryTabController.this.currentFrame.get() && frame.isTheChildrenListFinal()) {
                    StatisticsViewMemoryTabController.this.currentFrame.set((Object)frame);
                    navigationUriChangeEvent.getNewSnapshotProxy().submitTask(snapshot -> StatisticsViewMemoryTabController.this.updateAll(snapshot, (MemoryReportChannel)StatisticsViewMemoryTabController.this.selectedChannelProperty.get()));
                }
                return null;
            }
        }));
    }

    public @NonNull ReadOnlyStringProperty pieChartInfoLabelProperty() {
        return (ReadOnlyStringProperty)NullUtils.neverNull((Object)this.pieChartInfoLabel.getReadOnlyProperty());
    }

    public @NonNull SimpleObjectProperty<MemoryReportChannel> selectedChannelProperty() {
        return this.selectedChannelProperty;
    }

    public void showHistogramFor(@Nullable MemoryReportChannel channel) {
        assert (Platform.isFxApplicationThread());
        if (channel != null) {
            HistogramController.HistogramInformation histogramInfo = StatisticsViewMemoryTabController.createHistogramInfo(channel);
            this.showHistogram.set(true);
            this.histogramCategoryColourMap.clear();
            this.histogramCategoryTooltipMap.clear();
            this.histogramCategories.setAll(histogramInfo.getCategories());
            this.histogramCategoryColourMap.putAll(histogramInfo.getCategoryColours());
            this.histogramCategoryTooltipMap.putAll(histogramInfo.getCategoryTooltips());
            this.histogramSeries.setAll(histogramInfo.getSeriesToAdd());
            this.csv.set(histogramInfo.getCSVString());
        } else {
            this.showHistogram.set(false);
            this.histogramCategories.clear();
            this.histogramSeries.clear();
            this.histogramCategoryColourMap.clear();
            this.histogramCategoryTooltipMap.clear();
            this.csv.set(null);
        }
    }

    public ReadOnlyBooleanProperty showHistogramProperty() {
        return this.showHistogram.getReadOnlyProperty();
    }

    private void updateAll(@Nullable TraceStateSnapshot snapshot, @Nullable MemoryReportChannel currentChannel) {
        @NonNull List<SelectablePieChartController.SelectableData<MemoryReportChannel>> dataList = snapshot != null ? StatisticsViewMemoryTabController.getNewMemoryReportPieChartData(snapshot) : NullUtils.EMPTY_LIST;
        String currentChannelName = currentChannel != null ? currentChannel.getChannelName() : null;
        MemoryReportChannel newChannel = snapshot != null ? snapshot.getMemoryReportModel().getChannel(currentChannelName) : null;
        Platform.runLater(() -> {
            this.pieChartData.setAll((Collection)dataList);
            this.selectedChannelProperty.set((Object)newChannel);
            if (this.showHistogram.get()) {
                this.showHistogramFor(newChannel);
            }
        });
    }
}

