/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.statsview;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.counters.PerFrameStatistics;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.ui.Activator;
import com.arm.mgd.ui.UIUpdateTimerListener;
import com.arm.mgd.ui.controllers.NavigationChangeTableViewController;
import com.arm.mgd.ui.controllers.SimpleTableViewItem;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class StatisticsViewGeneralTabController
extends NavigationChangeTableViewController<SimpleTableViewItem>
implements UIUpdateTimerListener {
    private @NonNull WeakReference<@Nullable TraceDataModel> mostRecentModel = NullUtils.emptyWeakReference();
    private final @NonNull List<@NonNull SimpleTableViewItem> statistics = StatisticsViewGeneralTabController.createStatisticsList();
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;

    public StatisticsViewGeneralTabController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        Activator.uiUpdateTimer.addListener(this);
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, this.getNavigationChangedListener());
    }

    @Override
    public void dispose() {
        this.navigationChangedListener.dispose();
        Activator.uiUpdateTimer.removeListener(this);
    }

    @Override
    public void onTick() {
        Platform.runLater(() -> {
            TraceDataModel model = (TraceDataModel)this.mostRecentModel.get();
            if (model != null) {
                this.updateStatistics(model);
            }
        });
    }

    private static @NonNull List<@NonNull SimpleTableViewItem> createStatisticsList() {
        ArrayList<@NonNull SimpleTableViewItem> items = new ArrayList<SimpleTableViewItem>();
        items.add(new SimpleTableViewItem("Total number of API function calls"));
        items.add(new SimpleTableViewItem("Total number of frames"));
        items.add(new SimpleTableViewItem("Average vertices per frame"));
        items.add(new SimpleTableViewItem("Average instanced vertices per frame"));
        items.add(new SimpleTableViewItem("Average draw calls per frame"));
        items.add(new SimpleTableViewItem("Average memory allocated per frame (MB)"));
        return items;
    }

    private void updateStatistics(@NonNull TraceDataModel model) {
        assert (Platform.isFxApplicationThread());
        PerFrameStatistics perFrameStatistics = model.getStatistics();
        perFrameStatistics.updateStatistics();
        this.statistics.get(0).setValue(String.valueOf(model.count()));
        this.statistics.get(1).setValue(String.valueOf(model.getFrames().count()));
        this.statistics.get(2).setValue(String.format("%.2f", Float.valueOf(perFrameStatistics.getVerticesPerFrame())));
        this.statistics.get(3).setValue(String.format("%.2f", Float.valueOf(perFrameStatistics.getInstancedVerticesPerFrame())));
        this.statistics.get(4).setValue(String.format("%.2f", Float.valueOf(perFrameStatistics.getDrawCallsPerFrame())));
        this.statistics.get(5).setValue(String.format("%.2f", Float.valueOf(perFrameStatistics.getMemoryAllocatedPerFrame() / 1000000.0f)));
    }

    @Override
    protected final void refreshData(@Nullable TraceStateSnapshot snapshot) {
        TraceDataModel model = snapshot != null ? snapshot.getModel() : null;
        Platform.runLater(() -> {
            if (model != null) {
                this.mostRecentModel = new WeakReference<TraceDataModel>(model);
                this.updateStatistics(model);
                this.clearAndSetItems(this.statistics);
            } else {
                this.mostRecentModel = NullUtils.emptyWeakReference();
                this.clearItems();
            }
        });
    }
}

