/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.statsview;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.util.CommonStatistics;
import com.arm.mgd.core.util.IStatisticType;
import com.arm.mgd.core.util.Statistic;
import com.arm.mgd.core.util.executors.NamedSingleThreadExecutor;
import com.arm.mgd.ui.controls.SelectablePieChartController;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class StatisticsViewChartsTabController {
    private static final int NUMBER_OF_ENTRIES_TO_SHOW = 50;
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull ReadOnlyListWrapper<IStatisticType> availableStatistics = new ReadOnlyListWrapper(FXCollections.emptyObservableList());
    private final @NonNull ReadOnlyStringWrapper currentParentName = new ReadOnlyStringWrapper();
    private final @NonNull ReadOnlyBooleanWrapper isSelectedStatisticSupported = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ReadOnlyBooleanWrapper noDataToShow = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ReadOnlyIntegerWrapper numberOfEntries = new ReadOnlyIntegerWrapper(0);
    private final @NonNull ReadOnlyIntegerWrapper numberOfEntriesShown = new ReadOnlyIntegerWrapper(50);
    private final @NonNull ObservableList<SelectablePieChartController.SelectableData<INavigationElement<?>>> pieData = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull ObjectProperty<IStatisticType> selectedStatistic = new SimpleObjectProperty(null);
    private final @NonNull ObjectProperty<@Nullable INavigationElement<?>> selectedParentNavigationElement = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable INavigationElement<?>> selectedNavigationElement = new SimpleObjectProperty();
    private final @NonNull NamedSingleThreadExecutor executor = new NamedSingleThreadExecutor("StatisticsView chart statistics calculator", true);

    public StatisticsViewChartsTabController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.availableStatistics.set(FXCollections.observableArrayList((Object[])CommonStatistics.values()));
        this.selectedStatistic.addListener((observable, oldValue, newValue) -> {
            assert (Platform.isFxApplicationThread());
            if (oldValue != newValue) {
                this.updateStatistics((INavigationElement<?>)((INavigationElement)this.selectedParentNavigationElement.get()), (IStatisticType)newValue);
            }
        });
        this.selectedParentNavigationElement.addListener((observable, oldValue, newValue) -> {
            assert (Platform.isFxApplicationThread());
            String newName = newValue != null ? newValue.getLongLabelText() : null;
            this.currentParentName.set(newName);
            if (oldValue != newValue) {
                this.updateStatistics((INavigationElement<?>)newValue, (IStatisticType)this.selectedStatistic.get());
            }
        });
        this.noDataToShow.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.pieData.isEmpty(), (Observable[])new Observable[]{this.pieData}));
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public void dispose() {
        this.navigationChangedListener.dispose();
        Platform.runLater(() -> {
            this.selectedParentNavigationElement.set(null);
            this.selectedNavigationElement.set(null);
            this.executor.shutdown();
        });
    }

    private void updateStatistics(@Nullable INavigationElement<?> item, @Nullable IStatisticType statistic) {
        assert (Platform.isFxApplicationThread());
        this.executor.runLater(() -> {
            SortedList<SelectablePieChartController.SelectableData<INavigationElement<?>>> newStatistics;
            int numEntries;
            boolean doAnyChildrenSupportThisStatistic;
            if (statistic == null || item == null) {
                doAnyChildrenSupportThisStatistic = false;
                numEntries = 0;
                newStatistics = NullUtils.emptyList();
            } else {
                @NonNull ArrayList<SelectablePieChartController.SelectableData<INavigationElement<?>>> rawStatistics = new ArrayList();
                doAnyChildrenSupportThisStatistic = StatisticsViewChartsTabController.getRawStatistics(item, statistic, rawStatistics);
                numEntries = rawStatistics.size();
                newStatistics = StatisticsViewChartsTabController.getTrimmedSortedStatistics(rawStatistics);
            }
            Platform.runLater(() -> this.lambda$6(doAnyChildrenSupportThisStatistic, numEntries, (List)newStatistics));
        });
    }

    private static boolean getRawStatistics(@NonNull INavigationElement<?> parentItem, @NonNull IStatisticType statisticType, @NonNull List<SelectablePieChartController.SelectableData<INavigationElement<?>>> outData) {
        boolean doAnyChildrenSupportThisStatistic = false;
        for (INavigationElement child : parentItem.getChildren()) {
            if (!child.hasDataForStatisticType(statisticType)) continue;
            doAnyChildrenSupportThisStatistic = true;
            Statistic statistic = child.getStatistic(statisticType);
            Number statisticValue = statistic.getValue();
            if (statisticValue.doubleValue() == 0.0) continue;
            outData.add(new SelectablePieChartController.SelectableData<INavigationElement>(child.getLabelText(), statisticValue.doubleValue(), child, String.valueOf(child.getToolTipText()) + "\n" + statistic.getValueString()));
        }
        return doAnyChildrenSupportThisStatistic;
    }

    private static @NonNull SortedList<SelectablePieChartController.SelectableData<INavigationElement<?>>> getTrimmedSortedStatistics(@NonNull List<SelectablePieChartController.SelectableData<INavigationElement<?>>> navigationUriStatistics) {
        Collections.sort(navigationUriStatistics);
        List<SelectablePieChartController.SelectableData<INavigationElement<?>>> subList = navigationUriStatistics.subList(Math.max(navigationUriStatistics.size() - 50, 0), navigationUriStatistics.size());
        SortedList sortedList = new SortedList(FXCollections.observableArrayList(subList));
        sortedList.setComparator(new Comparator<SelectablePieChartController.SelectableData<INavigationElement<?>>>(){

            @Override
            public int compare(SelectablePieChartController.SelectableData<INavigationElement<?>> o1, SelectablePieChartController.SelectableData<INavigationElement<?>> o2) {
                INavigationElement n1 = (INavigationElement)o1.getLinkedItem().get();
                INavigationElement n2 = (INavigationElement)o2.getLinkedItem().get();
                int labelIndex1 = n1 != null ? n1.getLabelIndex() : Integer.MAX_VALUE;
                int labelIndex2 = n2 != null ? n2.getLabelIndex() : Integer.MAX_VALUE;
                return Integer.compare(labelIndex1, labelIndex2);
            }
        });
        return sortedList;
    }

    public @NonNull ReadOnlyStringProperty currentParentNameProperty() {
        return (ReadOnlyStringProperty)NullUtils.neverNull((Object)this.currentParentName.getReadOnlyProperty());
    }

    public void drillInto(@Nullable INavigationElement<?> navigationElement) {
        NavigationUri nextLevelUri;
        assert (Platform.isFxApplicationThread());
        if (navigationElement != null && (nextLevelUri = new NavigationUri(navigationElement).selectFirstInNextLevel()) != null) {
            CoreInstance.getNavigationManager().setNavigationURI(nextLevelUri, (Object)this);
        }
    }

    public @NonNull ReadOnlyListProperty<IStatisticType> getAvailableStatistics() {
        return (ReadOnlyListProperty)NullUtils.neverNull((Object)this.availableStatistics.getReadOnlyProperty());
    }

    public ReadOnlyIntegerProperty getNumberOfEntriesShownProperty() {
        return this.numberOfEntriesShown.getReadOnlyProperty();
    }

    public @NonNull ObservableList<SelectablePieChartController.SelectableData<INavigationElement<?>>> getPieData() {
        return this.pieData;
    }

    public ReadOnlyIntegerProperty getTotalNumberOfEntriesProperty() {
        return this.numberOfEntries.getReadOnlyProperty();
    }

    public @NonNull ReadOnlyBooleanProperty isSelectedStatisticSupportedProperty() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.isSelectedStatisticSupported.getReadOnlyProperty());
    }

    public @NonNull ReadOnlyBooleanProperty noDataToShowProperty() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.noDataToShow.getReadOnlyProperty());
    }

    public void select(@Nullable INavigationElement<?> navigationElement) {
        assert (Platform.isFxApplicationThread());
        if (navigationElement != null) {
            NavigationUri newURI = new NavigationUri(navigationElement);
            CoreInstance.getNavigationManager().setNavigationURI(newURI, (Object)this);
        }
    }

    public ObservableValue<INavigationElement<?>> selectedNavigationElementProperty() {
        return this.selectedNavigationElement;
    }

    public @NonNull ObjectProperty<IStatisticType> selectedStatisticProperty() {
        return this.selectedStatistic;
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        Platform.runLater(() -> navigationUriChangeEvent.getNewMostSpecificAndParentItems((newMostSpecificItem, newParentItem) -> {
            this.selectedNavigationElement.set(newMostSpecificItem);
            this.selectedParentNavigationElement.set(newParentItem);
            return null;
        }));
    }

    private /* synthetic */ void lambda$6(boolean bl, int n, List list) {
        this.isSelectedStatisticSupported.set(bl);
        this.numberOfEntries.set(n);
        this.numberOfEntriesShown.set(list.size());
        this.pieData.setAll((Collection)list);
    }
}

