/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.framebuffer;

import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.ui.controllers.framebuffer.AbstractFramebufferPerPixelHistogramInfoTask;
import com.arm.mgd.ui.controls.HistogramController;
import com.arm.mgd.ui.controls.HistogramViewItem;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class ShadermapInfoTask
extends AbstractFramebufferPerPixelHistogramInfoTask {
    private final @NonNull List<@NonNull GlShaderAsset> selectedFragmentShaders;
    private final Map<List<Long>, GlProgramAsset> cachedColourToProgramMap = new HashMap<List<Long>, GlProgramAsset>();

    ShadermapInfoTask(@NonNull GlFramebufferAsset framebuffer, @NonNull List<@NonNull GlShaderAsset> selectedFragmentShaders) {
        super(framebuffer);
        this.selectedFragmentShaders = selectedFragmentShaders;
    }

    @Override
    public @NonNull String getName() {
        return "Shader map";
    }

    @Override
    protected void processPixel(HistogramController.HistogramInformation info, HistogramViewItem<GlFramebufferAsset> item, long[] rgba) {
        List<Long> key = Arrays.asList(rgba[0], rgba[1], rgba[2], rgba[3]);
        GlProgramAsset selectedProgram = null;
        if (this.cachedColourToProgramMap.containsKey(key)) {
            selectedProgram = this.cachedColourToProgramMap.get(key);
        } else {
            int[] selectedShaderColour = null;
            int minDistance = Integer.MAX_VALUE;
            for (GlShaderAsset element : this.selectedFragmentShaders) {
                for (GlProgramAsset program : element.getLinkedToProgramList()) {
                    int[] shaderColor = program.getColor().getColorAsInt();
                    int distance = (int)(Math.abs((long)shaderColor[0] - rgba[0]) + Math.abs((long)shaderColor[1] - rgba[1]) + Math.abs((long)shaderColor[2] - rgba[2]));
                    if (distance >= minDistance) continue;
                    minDistance = distance;
                    selectedShaderColour = shaderColor;
                    selectedProgram = program;
                }
            }
            if (selectedProgram != null) {
                info.setCategoryColour(selectedProgram.getId().toString(), selectedShaderColour);
                this.cachedColourToProgramMap.put(key, selectedProgram);
            }
        }
        if (selectedProgram != null) {
            String bin = selectedProgram.getId().toString();
            item.incBin(this.framebuffer, bin);
        }
    }

    @Override
    protected void addMissingCategories(HistogramController.HistogramInformation info, HistogramViewItem<GlFramebufferAsset> histogramViewItem) {
    }

    @Override
    protected @Nullable Comparator<String> getComparator() {
        return null;
    }

    @Override
    protected @NonNull String getFrequencyLabel() {
        return "Pixel Count";
    }

    @Override
    protected @NonNull String getCategoriesLabel() {
        return "Program ID";
    }
}

