/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.framebuffer;

import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.ui.controllers.framebuffer.AbstractFramebufferPerPixelHistogramInfoTask;
import com.arm.mgd.ui.controls.HistogramController;
import com.arm.mgd.ui.controls.HistogramViewItem;
import com.arm.mgd.ui.utils.NumberMultipleStringComparator;
import com.arm.mgd.ui.views.FramebufferInfoStringHelper;
import java.util.Comparator;
import javafx.collections.ObservableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class OverdrawInfoTask
extends AbstractFramebufferPerPixelHistogramInfoTask {
    private static final int[] barColour = new int[]{30, 144, 255};

    OverdrawInfoTask(@NonNull GlFramebufferAsset framebuffer) {
        super(framebuffer);
    }

    @Override
    public @NonNull String getName() {
        return "Overdraw";
    }

    @Override
    protected void processPixel(HistogramController.HistogramInformation info, HistogramViewItem<GlFramebufferAsset> item, long[] rgba) {
        String bin = FramebufferInfoStringHelper.getOverdrawFactor(rgba);
        item.incBin(this.framebuffer, bin);
        info.setCategoryColour(bin, barColour);
    }

    @Override
    protected void addMissingCategories(HistogramController.HistogramInformation info, HistogramViewItem<GlFramebufferAsset> histogramViewItem) {
        ObservableList<String> allCategories = histogramViewItem.getAllCategories();
        String lastCategory = (String)allCategories.get(allCategories.size() - 1);
        int maxOverdraw = 0;
        maxOverdraw = lastCategory.equals(FramebufferInfoStringHelper.SATURATION_OVERDRAW_FACTOR_LABEL) ? FramebufferInfoStringHelper.SATURATION_OVERDRAW_FACTOR : Integer.parseInt(lastCategory.substring(0, lastCategory.length() - 1));
        assert (this.framebuffer != null);
        int i = 0;
        while (i <= maxOverdraw) {
            String categoryName = String.valueOf(Integer.valueOf(i).toString()) + "x";
            if (!allCategories.contains((Object)categoryName)) {
                histogramViewItem.addEmptyBin(this.framebuffer, categoryName);
                info.setCategoryColour(categoryName, barColour);
            }
            ++i;
        }
    }

    @Override
    protected @Nullable Comparator<String> getComparator() {
        return new NumberMultipleStringComparator();
    }

    @Override
    protected @NonNull String getFrequencyLabel() {
        return "Pixel Count";
    }

    @Override
    protected @NonNull String getCategoriesLabel() {
        return "Overdraw";
    }
}

