/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.framebuffer;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.GlFramebufferAttachmentAsset;
import com.arm.mgd.core.asset.GlFramebufferAttachmentBinding;
import com.arm.mgd.core.asset.GlFramebufferTextureMultiviewAttachmentAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.GlShaderHelper;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.FramebufferFeature;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.controllers.framebuffer.AbstractFramebufferPerPixelHistogramInfoTask;
import com.arm.mgd.ui.controllers.framebuffer.FramebufferAttachmentData;
import com.arm.mgd.ui.controllers.framebuffer.FramebufferData;
import com.arm.mgd.ui.controllers.framebuffer.OverdrawInfoTask;
import com.arm.mgd.ui.controllers.framebuffer.ShadermapInfoTask;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FramebuffersViewController {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull ObjectProperty<@Nullable Framebuffers> framebuffersProperty = new SimpleObjectProperty();

    public FramebuffersViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public void close() {
        this.navigationChangedListener.dispose();
        this.framebuffersProperty.set(null);
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        navigationUriChangeEvent.getNewSnapshotProxy().submitTask(snapshot -> {
            @Nullable Framebuffers framebuffers = FramebuffersViewController.getFramebuffers(snapshot);
            Platform.runLater(() -> this.framebuffersProperty.set((Object)framebuffers));
        });
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable Framebuffers> framebuffersProperty() {
        return this.framebuffersProperty;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @Nullable Framebuffers getFramebuffers(@Nullable TraceStateSnapshot snapshot) {
        if (snapshot == null || snapshot.getCurrentSelection() == -1) {
            return null;
        }
        ArrayList<@NonNull FramebufferInfo> newItems = new ArrayList<FramebufferInfo>();
        AssetTable framebufferAssetTable = snapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS.SPEC);
        @NonNull @NonNull List fragmentShaders = GlShaderHelper.getAllLinkedShaders((TraceStateSnapshot)snapshot, (AbstractConstantOrAliasSpecExtended)KapiSpec.GLES.constants.GL_FRAGMENT_SHADER);
        for (IAssetItem asset : framebufferAssetTable) {
            FramebufferData framebufferData = new FramebufferData((GlFramebufferAsset)asset);
            FramebufferAttachments attachments = FramebuffersViewController.getFramebufferAttachments(framebufferData, fragmentShaders);
            newItems.add(new FramebufferInfo(framebufferData, attachments));
        }
        return new Framebuffers(newItems, fragmentShaders);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull FramebufferAttachments getFramebufferAttachments(@NonNull FramebufferData framebufferData, @NonNull List<@NonNull GlShaderAsset> fragmentShaders) {
        ArrayList<@NonNull FramebufferAttachmentData> attachments = new ArrayList<FramebufferAttachmentData>();
        @NonNull GlFramebufferAsset framebuffer = framebufferData.getFramebuffer();
        @NonNull Map attachmentsMap = framebuffer.getAttachmentMap();
        for (AbstractConstantOrAliasSpecExtended target : attachmentsMap.keySet()) {
            int numberOfViewsInAttachment = FramebuffersViewController.getNumViews(framebuffer, target);
            if (numberOfViewsInAttachment > 1) {
                int viewIndex = 0;
                while (viewIndex < numberOfViewsInAttachment) {
                    attachments.add(new FramebufferAttachmentData(framebufferData, target, NullUtils.intValueOf((int)viewIndex)));
                    ++viewIndex;
                }
                continue;
            }
            attachments.add(new FramebufferAttachmentData(framebufferData, target, null));
        }
        ArrayList<@NonNull HistogramTaskFactory> histogramFactories = new ArrayList<HistogramTaskFactory>();
        FramebufferFeature.CaptureMode captureMode = framebufferData.getCaptureMode();
        if (captureMode == FramebufferFeature.CaptureMode.SHADER_MAP) {
            histogramFactories.add(() -> new ShadermapInfoTask(framebufferData.getFramebuffer(), fragmentShaders));
        } else if (captureMode == FramebufferFeature.CaptureMode.OVERDRAW) {
            histogramFactories.add(() -> new OverdrawInfoTask(framebufferData.getFramebuffer()));
        }
        return new FramebufferAttachments(attachments, histogramFactories);
    }

    private static int getNumViews(@NonNull GlFramebufferAsset framebuffer, @NonNull AbstractConstantOrAliasSpecExtended attachment) {
        @Nullable GlFramebufferAttachmentBinding binding = framebuffer.getAttachmentBinding(attachment);
        if (binding == null) {
            return 0;
        }
        @NonNull GlFramebufferAttachmentAsset framebufferAttachmentAsset = binding.getAsset();
        if (framebufferAttachmentAsset instanceof GlFramebufferTextureMultiviewAttachmentAsset) {
            @Nullable GlFramebufferTextureMultiviewAttachmentAsset multiviewAttachmentAsset = (GlFramebufferTextureMultiviewAttachmentAsset)framebufferAttachmentAsset;
            return multiviewAttachmentAsset.getNumViews();
        }
        return 1;
    }

    public static class FramebufferAttachments {
        public final @NonNull List<@NonNull FramebufferAttachmentData> attachments;
        public final @NonNull List<@NonNull HistogramTaskFactory> histogramTaskFactories;

        private FramebufferAttachments(@NonNull List<@NonNull FramebufferAttachmentData> attachments, @NonNull List<@NonNull HistogramTaskFactory> histogramTaskFactories) {
            this.attachments = NullUtils.unmodifiableList(attachments);
            this.histogramTaskFactories = NullUtils.unmodifiableList(histogramTaskFactories);
        }
    }

    public static class FramebufferInfo {
        public final @NonNull FramebufferData framebuffer;
        public final @NonNull FramebufferAttachments attachments;

        private FramebufferInfo(@NonNull FramebufferData framebuffer, @NonNull FramebufferAttachments attachments) {
            this.framebuffer = framebuffer;
            this.attachments = attachments;
        }
    }

    public static class Framebuffers {
        public final @NonNull List<@NonNull FramebufferInfo> framebuffers;
        public final @NonNull List<@NonNull GlShaderAsset> fragmentShaders;

        private Framebuffers(@NonNull List<@NonNull FramebufferInfo> framebuffers, @NonNull List<@NonNull GlShaderAsset> fragmentShaders) {
            this.framebuffers = NullUtils.unmodifiableList(framebuffers);
            this.fragmentShaders = NullUtils.unmodifiableList(fragmentShaders);
        }
    }

    public static interface HistogramTaskFactory {
        public @NonNull AbstractFramebufferPerPixelHistogramInfoTask create();
    }
}

