/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.framebuffer;

import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.target.data.FramebufferFeature;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.controllers.framebuffer.FramebufferData;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FramebufferAttachmentData {
    private final @NonNull FramebufferData framebufferData;
    private final @NonNull AbstractConstantOrAliasSpecExtended attachment;
    private final @Nullable Integer multiViewId;
    private final boolean isActive;
    private final boolean isAlphaOpacity;

    FramebufferAttachmentData(@NonNull FramebufferData framebufferData, @NonNull AbstractConstantOrAliasSpecExtended attachment, @Nullable Integer multiViewId) {
        this.framebufferData = framebufferData;
        this.attachment = attachment;
        this.multiViewId = multiViewId;
        this.isActive = FramebufferAttachmentData.isAttachmentActive(this.getFramebuffer(), attachment);
        boolean noModifyFeaturesEnabled = this.getCaptureMode() == FramebufferFeature.CaptureMode.NONE || this.getCaptureMode() == FramebufferFeature.CaptureMode.CAPTURE_ALL_ATTACHMENTS;
        boolean isColourAttachment = attachment != KapiSpec.GLES.constants.GL_STENCIL_ATTACHMENT && attachment != KapiSpec.GLES.constants.GL_DEPTH_ATTACHMENT;
        this.isAlphaOpacity = noModifyFeaturesEnabled && isColourAttachment;
    }

    public @NonNull GlFramebufferAsset getFramebuffer() {
        return this.framebufferData.getFramebuffer();
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getAttachment() {
        return this.attachment;
    }

    public @Nullable Integer getMultiViewId() {
        return this.multiViewId;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull FramebufferFeature.CaptureMode getCaptureMode() {
        return this.framebufferData.getCaptureMode();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isAlphaOpacity() {
        return this.isAlphaOpacity;
    }

    private static boolean isAttachmentActive(@NonNull GlFramebufferAsset framebuffer, @NonNull AbstractConstantOrAliasSpecExtended attachment) {
        TraceStateSnapshot snapshot = framebuffer.getSnapshotAssetParent().getTraceStateSnapshot();
        if (attachment.equals(KapiSpec.GLES.constants.GL_DEPTH_ATTACHMENT)) {
            StateItem si = snapshot.getStateItemBySpec(KapiSpec.GLES.states.GL_DEPTH_TEST);
            if (si.getValue()[0].value.equals(KapiSpec.GLES.constants.GL_TRUE)) {
                return true;
            }
        } else if (attachment.equals(KapiSpec.GLES.constants.GL_STENCIL_ATTACHMENT)) {
            StateItem si = snapshot.getStateItemBySpec(KapiSpec.GLES.states.GL_STENCIL_TEST);
            if (si.getValue()[0].value.equals(KapiSpec.GLES.constants.GL_TRUE)) {
                return true;
            }
        } else if (framebuffer.getDrawBuffers().contains(attachment)) {
            return true;
        }
        return false;
    }
}

