/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.framebuffer;

import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.texture.IGlImageProvider;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.asset.texture.RGBAImageData;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.image.IntegerTextureConverter;
import com.arm.mgd.core.util.image.PixelReader;
import com.arm.mgd.ui.controls.HistogramController;
import com.arm.mgd.ui.controls.HistogramViewItem;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.chart.XYChart;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractFramebufferPerPixelHistogramInfoTask
extends Task<HistogramController.HistogramInformation> {
    protected final @NonNull GlFramebufferAsset framebuffer;

    AbstractFramebufferPerPixelHistogramInfoTask(@NonNull GlFramebufferAsset framebuffer) {
        this.framebuffer = framebuffer;
    }

    protected HistogramController.HistogramInformation call() {
        HistogramViewItem<GlFramebufferAsset> histogramViewItem = new HistogramViewItem<GlFramebufferAsset>();
        HistogramController.HistogramInformation info = new HistogramController.HistogramInformation();
        ObservableList seriesToAdd = FXCollections.observableArrayList();
        histogramViewItem.addSeries(this.framebuffer);
        IGlImageProvider imageProvider = this.framebuffer.getMainColourAttachmentImageProvider();
        try {
            RGBAImageData imageData = imageProvider.getImageData();
            Dimension size = imageData.getSize();
            PixelReader.IPixelReader pixelReader = IntegerTextureConverter.getRGBA8PixelReader();
            ByteBuffer data = imageData.getData().getData();
            int y = 0;
            while (y < size.getHeight()) {
                int x = 0;
                while (x < size.getWidth()) {
                    long[] rgba = pixelReader.getPixelData(data, size.getWidth(), x, y);
                    this.processPixel(info, histogramViewItem, rgba);
                    ++x;
                }
                if (!this.isCancelled()) {
                    ++y;
                    continue;
                }
                break;
            }
        }
        catch (IImageProvider.ImageConversionException | IImageProvider.ImageDataUnavailableException | IOException imageData) {
            // empty catch block
        }
        this.addMissingCategories(info, histogramViewItem);
        XYChart.Series series = new XYChart.Series();
        series.setName("Framebuffer " + this.framebuffer.getId().toString());
        for (String category : histogramViewItem.getCategories(this.framebuffer)) {
            Integer count = histogramViewItem.getCount(this.framebuffer, category);
            series.getData().add((Object)new XYChart.Data((Object)category, (Object)count));
        }
        seriesToAdd.add((Object)series);
        info.setCategories(histogramViewItem.getAllCategories());
        info.setSeriesToAdd((ObservableList<XYChart.Series<String, Number>>)seriesToAdd);
        info.setCategoriesLabel(this.getCategoriesLabel());
        info.setFrequencyLabel(this.getFrequencyLabel());
        info.setComparator(this.getComparator());
        return info;
    }

    public abstract @NonNull String getName();

    protected abstract @Nullable Comparator<String> getComparator();

    protected abstract @NonNull String getFrequencyLabel();

    protected abstract @NonNull String getCategoriesLabel();

    protected abstract void processPixel(HistogramController.HistogramInformation var1, HistogramViewItem<GlFramebufferAsset> var2, long[] var3);

    protected abstract void addMissingCategories(HistogramController.HistogramInformation var1, HistogramViewItem<GlFramebufferAsset> var2);
}

