/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mali.mgd.editors.SourceEditor;
import com.arm.mgd.core.asset.SourceProvider;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.shader.ForcePrecisionModeOverride;
import com.arm.mgd.core.replay.shader.ProgramOverride;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.FrameOverridesViewListItem;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.editorinput.SourceEditorInput;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

class ViewFrameOverrideCommand
implements ICommand<FrameOverridesViewListItem> {
    ViewFrameOverrideCommand() {
    }

    @Override
    public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends FrameOverridesViewListItem> selection) {
        if (selection.isEmpty()) {
            return;
        }
        AbstractFrameOverride override = selection.get(0).getOverride();
        if (model != null && override instanceof ProgramOverride && !(override instanceof ForcePrecisionModeOverride)) {
            ProgramOverride po = (ProgramOverride)override;
            SourceProvider vertexSource = po.getNewVertexShader();
            SourceProvider fragmentSource = po.getNewFragmentShader();
            SourceEditorInput vertexEditorInput = new SourceEditorInput(vertexSource, model);
            SourceEditorInput fragmentEditorInput = new SourceEditorInput(fragmentSource, model);
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)vertexEditorInput, SourceEditor.getID());
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)fragmentEditorInput, SourceEditor.getID());
            }
            catch (PartInitException e) {
                CoreLogging.warning(null, (Throwable)e, null);
            }
        }
    }

    @Override
    public @NonNull String getLabel() {
        return "Open Override in Shader Editor";
    }

    @Override
    public boolean isEnabled(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends FrameOverridesViewListItem> selection) {
        if (model != null && selection.size() == 1 && model.containsOnlyGLESAndEGL()) {
            AbstractFrameOverride override = selection.get(0).getOverride();
            return override instanceof ProgramOverride && !(override instanceof ForcePrecisionModeOverride);
        }
        return false;
    }
}

