/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.IAssetWrapper;
import com.arm.mgd.ui.controllers.commands.ICommand;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ShowCreatedByFunctionCommand
implements ICommand<IAssetWrapper<?>> {
    @Override
    public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends IAssetWrapper<?>> selectedItems) {
        if (selectedItems.size() == 1) {
            IAssetWrapper<?> item = selectedItems.get(0);
            @Nullable ? assetItem = item.getAsset();
            if (assetItem == null) {
                return;
            }
            CoreInstance.getNavigationManager().setNavigationURI(new NavigationUri((INavigationElement)assetItem.getCreatedByFunction()), (Object)this);
        }
    }

    @Override
    public @NonNull String getLabel() {
        return "Show Creating Function";
    }

    @Override
    public boolean isEnabled(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends IAssetWrapper<?>> selectedItems) {
        IAssetWrapper<?> item;
        Object assetItem;
        @Nullable FunctionCall functionCall = CoreInstance.getNavigationManager().getActiveFunctionCall();
        if (functionCall != null && functionCall.getModel() == model && selectedItems.size() == 1 && (assetItem = (item = selectedItems.get(0)).getAsset()) != null) {
            return !(assetItem.getCreatedByFunction() instanceof TraceDataModel.DummyFunctionCall) && functionCall.getIndex() != assetItem.getCreatedByFunction().getIndex();
        }
        return false;
    }
}

