/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.IAssetWrapper;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.propertytesters.OverridePropertyTester;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class RemoveTextureOverrideCommand
implements ICommand<IAssetWrapper<GlTextureAsset>> {
    @Override
    public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends IAssetWrapper<GlTextureAsset>> selectedItems) {
        IAssetWrapper<GlTextureAsset> item;
        GlTextureAsset textureAsset;
        assert (selectedItems.size() != 0);
        if (model == null) {
            return;
        }
        if (selectedItems.size() == 1 && (textureAsset = (item = selectedItems.get(0)).getAsset()) != null) {
            model.getCurrentActiveOverrides().remove(FrameOverrides.OverrideType.TEXTURE_OVERRIDE, (IAssetItem)textureAsset);
        }
    }

    @Override
    public @NonNull String getLabel() {
        return "Remove Texture Override";
    }

    @Override
    public boolean isEnabled(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends IAssetWrapper<GlTextureAsset>> selectedItems) {
        IAssetWrapper<GlTextureAsset> item;
        GlTextureAsset textureAsset;
        if (model == null) {
            return false;
        }
        if (selectedItems.size() == 1 && (textureAsset = (item = selectedItems.get(0)).getAsset()) != null) {
            return OverridePropertyTester.testTexture(model, textureAsset, OverridePropertyTester.OverrideProperty.REMOVE_TEXTURE);
        }
        return false;
    }
}

