/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.controllers.commands.AbstractShaderOverrideCommand;
import com.arm.mgd.ui.controllers.commands.OverrideWizardHelper;
import com.arm.mgd.ui.dialogs.replayoverridewizard.AbstractSecondPage;
import com.arm.mgd.ui.dialogs.replayoverridewizard.MinimalFrameReplayOverrideWizard;
import com.arm.mgd.ui.propertytesters.OverridePropertyTester;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class RemoveProgramOverrideCommand
extends AbstractShaderOverrideCommand {
    @Override
    protected void handleSelectedAssetItem(TraceDataModel model, GlProgramAsset assetItem) {
        FrameOverrides.OverrideType overrideType;
        FrameOverrides modelOverrides;
        if (model != null && (modelOverrides = model.getCurrentActiveOverrides()).contains(overrideType = FrameOverrides.OverrideType.PROGRAM_OVERRIDE, (IAssetItem)assetItem)) {
            model.getCurrentActiveOverrides().remove(overrideType, (IAssetItem)assetItem);
        }
    }

    @Override
    public @NonNull String getLabel() {
        return "Remove Program Override";
    }

    @Override
    protected boolean isEnabledFor(TraceDataModel model, GlProgramAsset assetItem) {
        return OverridePropertyTester.testProgramOverride(model, assetItem, OverridePropertyTester.OverrideProperty.REMOVE_PROGRAM);
    }

    @Override
    protected void handleSelectedAssetItem(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends GlProgramAsset> assetItemList) {
        assert (!assetItemList.isEmpty());
        OverrideWizardHelper.createSnapshotWizard(this.getLabel(), model, (latestSnapshot, selectedSnapshot) -> new MinimalFrameReplayOverrideWizard(latestSnapshot, selectedSnapshot, FrameOverrides.OverrideType.PROGRAM_OVERRIDE, assetItemList, AbstractSecondPage.Mode.REMOVE));
    }
}

