/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.ui.Activator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

class OverrideWizardHelper {
    OverrideWizardHelper() {
    }

    static void createSnapshotWizard(@NonNull String commandName, final @Nullable TraceDataModel model, final @NonNull OverrideWizardFactory wizardFactory) {
        if (model == null) {
            return;
        }
        final @Nullable FunctionCall selectedFunction = CoreInstance.getNavigationManager().getActiveFunctionCall();
        if (selectedFunction == null || selectedFunction.getModel() != model) {
            return;
        }
        Job job = new Job("Launching " + commandName + " Wizard"){

            protected IStatus run(IProgressMonitor monitor) {
                SynchronousTraceStateSnapshot latestStateSnapshot = model.createLatestSnapshot();
                SynchronousTraceStateSnapshot selectedStateSnapshot = new SynchronousTraceStateSnapshot(model, selectedFunction.getIndex());
                Wizard wizard = wizardFactory.create((TraceStateSnapshot)latestStateSnapshot, (TraceStateSnapshot)selectedStateSnapshot);
                Display.getDefault().asyncExec(() -> {
                    int n = new WizardDialog(Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard).open();
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    static interface OverrideWizardFactory {
        public @NonNull Wizard create(@NonNull TraceStateSnapshot var1, @NonNull TraceStateSnapshot var2);
    }
}

