/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.help.ApiDocProvider;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.ui.Activator;
import com.arm.mgd.ui.controllers.commands.ICommand;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class OpenDocumentationCommand
implements ICommand<FunctionCall> {
    private static void openDocumentation(final FunctionCall functionCall) {
        if (functionCall != null) {
            Thread openURLThread = new Thread("OpenURLThread"){

                @Override
                public void run() {
                    URL url = ApiDocProvider.getApiDocLocation((Object)functionCall.getFunctionSpec());
                    try {
                        ApiDocProvider.checkURLValid((URL)url);
                        Activator.openBrowser(url, functionCall.getFunctionSpec().getName());
                    }
                    catch (Exception e) {
                        CoreLogging.userMessage((ICoreLoggingSource)functionCall.getModel(), (Level)Level.WARNING, (String)(String.valueOf(e.getMessage()) + "\nCannot open page for the function '" + functionCall.getFunctionSpec().getName() + "'.\nPlease check your internet connection and try to load: " + url));
                    }
                }
            };
            openURLThread.start();
        }
    }

    @Override
    public @NonNull String getLabel() {
        return "Open Documentation";
    }

    @Override
    public boolean isEnabled(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends FunctionCall> selectedItems) {
        return selectedItems.size() == 1;
    }

    @Override
    public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends FunctionCall> selectedItems) {
        if (selectedItems.isEmpty()) {
            return;
        }
        FunctionCall functionCall = selectedItems.get(0);
        OpenDocumentationCommand.openDocumentation(functionCall);
    }
}

