/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.diff.DiffItem;
import com.arm.mgd.core.diff.DiffService;
import com.arm.mgd.core.diff.IDiffable;
import com.arm.mgd.core.diff.NotDiffableException;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.utils.SimpleCoreProgressMonitor;
import com.arm.mgd.ui.views.DiffReportView;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;

public class GenerateDiffCommand
implements ICommand<INavigationElement<?>> {
    @Override
    public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends INavigationElement<?>> selection) {
        assert (selection.size() == 2);
        @NonNull INavigationElement<?> s0 = selection.get(0);
        @NonNull INavigationElement<?> s1 = selection.get(1);
        if (!(s0 instanceof IDiffable) || !(s1 instanceof IDiffable)) {
            return;
        }
        final IDiffable o1 = (IDiffable)s0;
        final IDiffable o2 = (IDiffable)s1;
        Job job = new Job("Generating Diff"){

            protected IStatus run(IProgressMonitor monitor) {
                block3: {
                    try {
                        final DiffItem diffItem = DiffService.generate((IDiffable)o1, (IDiffable)o2, (ICoreProgressMonitor)new SimpleCoreProgressMonitor(monitor));
                        if (diffItem != null) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    block2: {
                                        try {
                                            DiffReportView.activateNewView(diffItem);
                                        }
                                        catch (PartInitException e) {
                                            e.printStackTrace();
                                            if ($assertionsDisabled) break block2;
                                            throw new AssertionError();
                                        }
                                    }
                                }
                            });
                        }
                    }
                    catch (NotDiffableException e1) {
                        e1.printStackTrace();
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    @Override
    public @NonNull String getLabel() {
        return "Generate Diff";
    }

    @Override
    public boolean isEnabled(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends INavigationElement<?>> selection) {
        FunctionCall functionCall;
        if (selection.size() != 2) {
            return false;
        }
        @NonNull INavigationElement<?> s0 = selection.get(0);
        @NonNull INavigationElement<?> s1 = selection.get(1);
        if (!(s0 instanceof IDiffable) || !(s1 instanceof IDiffable)) {
            return false;
        }
        IDiffable o1 = (IDiffable)s0;
        IDiffable o2 = (IDiffable)s1;
        if (o1 instanceof FunctionCall && !GenerateDiffCommand.isGLESFunction(functionCall = (FunctionCall)o1)) {
            return false;
        }
        if (o2 instanceof FunctionCall && !GenerateDiffCommand.isGLESFunction(functionCall = (FunctionCall)o2)) {
            return false;
        }
        return DiffService.isDiffable((IDiffable)o1, (IDiffable)o2);
    }

    private static boolean isGLESFunction(@NonNull FunctionCall functionCall) {
        return KapiSpec.GLES.equals(functionCall.getFunctionSpec().getKapiSpec()) || KapiSpec.EGL.equals(functionCall.getFunctionSpec().getKapiSpec());
    }
}

