/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers.commands;

import com.arm.mgd.core.asset.GlShaderHelper;
import com.arm.mgd.core.authorisation.ApplicationFeatureAuthoriser;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.utils.FileDialogHelper;
import com.arm.mgd.ui.utils.GUIExporterController;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ExportShadersForFrameCommand
implements ICommand<INavigationElement<?>> {
    @Override
    public @NonNull String getLabel() {
        return "Export shaders for frame";
    }

    @Override
    public boolean isEnabled(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends INavigationElement<?>> selectedItems) {
        if (!ApplicationFeatureAuthoriser.RESOURCES_EXPORT.isAuthorisationReceivedAndApproved() || selectedItems.size() != 1) {
            return false;
        }
        INavigationElement<?> item = selectedItems.get(0);
        if (!(item instanceof Frame)) {
            return false;
        }
        Frame frame = (Frame)item;
        SynchronousTraceStateSnapshot snapshot = new SynchronousTraceStateSnapshot(frame.getParentModel());
        snapshot.setSelectedFunction(frame.getLastFunctionIndex());
        return GlShaderHelper.snapshotHasShaders((TraceStateSnapshot)snapshot);
    }

    @Override
    public void execute(@Nullable TraceDataModel model, @NonNull List<@NonNull ? extends INavigationElement<?>> list) {
        if (!this.isEnabled(model, (List<? extends INavigationElement<?>>)list)) {
            return;
        }
        assert (list.size() == 1);
        Frame frame = (Frame)list.get(0);
        int frameIndex = frame.getId();
        File selectedDir = FileDialogHelper.promptForDirectory(null);
        if (selectedDir != null) {
            Job j = GUIExporterController.exportAllShadersAtFrame(frame.getParentModel(), frameIndex, selectedDir);
            FileDialogHelper.openFileAfterJobComplete(j, selectedDir);
        }
    }
}

